/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.condition;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import liedge.limacore.lib.math.CompareOperation;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record NumberComparisonLootCondition(NumberProvider first, NumberProvider second, CompareOperation operation) implements LootItemCondition
{
    public static final MapCodec<NumberComparisonLootCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("first").forGetter(NumberComparisonLootCondition::first), (App)NumberProviders.CODEC.fieldOf("second").forGetter(NumberComparisonLootCondition::second), (App)CompareOperation.CODEC.fieldOf("operation").forGetter(NumberComparisonLootCondition::operation)).apply((Applicative)instance, NumberComparisonLootCondition::new));

    public static LootItemCondition.Builder comparingValues(NumberProvider first, NumberProvider second, CompareOperation operation) {
        return () -> new NumberComparisonLootCondition(first, second, operation);
    }

    public LootItemConditionType getType() {
        return (LootItemConditionType)LimaCoreLootRegistries.NUMBER_COMPARISON_CONDITION.get();
    }

    public boolean test(LootContext context) {
        return this.operation().test(this.first.getFloat(context), this.second.getFloat(context));
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Sets.union((Set)this.first.getReferencedContextParams(), (Set)this.second.getReferencedContextParams());
    }
}

