/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import liedge.limacore.world.loot.number.LootPositionSource;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import net.minecraft.world.phys.Vec3;

public record DistanceNumberProvider(LootPositionSource origin, LootPositionSource end, NumberProvider fallback) implements NumberProvider
{
    public static final MapCodec<DistanceNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LootPositionSource.CODEC.fieldOf("origin").forGetter(DistanceNumberProvider::origin), (App)LootPositionSource.CODEC.fieldOf("end").forGetter(DistanceNumberProvider::end), (App)NumberProviders.CODEC.optionalFieldOf("fallback", (Object)ConstantValue.exactly((float)-1.0f)).forGetter(DistanceNumberProvider::fallback)).apply((Applicative)instance, DistanceNumberProvider::new));

    public float getFloat(LootContext lootContext) {
        Vec3 a = this.origin.get(lootContext);
        Vec3 b = this.end.get(lootContext);
        return a != null && b != null ? (float)a.distanceTo(b) : this.fallback.getFloat(lootContext);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)LimaCoreLootRegistries.DISTANCE_NUMBER_PROVIDER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return Stream.of(this.origin, this.end, this.fallback).flatMap(o -> o.getReferencedContextParams().stream()).collect(Collectors.toSet());
    }
}

