/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.world.item.enchantment.LevelBasedValue;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record LevelBasedNumberProvider(NumberProvider input, LevelBasedValue formula) implements NumberProvider
{
    public static final MapCodec<LevelBasedNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("input").forGetter(LevelBasedNumberProvider::input), (App)LevelBasedValue.CODEC.fieldOf("formula").forGetter(LevelBasedNumberProvider::formula)).apply((Applicative)instance, LevelBasedNumberProvider::new));

    public static LevelBasedNumberProvider of(NumberProvider input, LevelBasedValue formula) {
        return new LevelBasedNumberProvider(input, formula);
    }

    public float getFloat(LootContext context) {
        int level = Math.max(1, this.input.getInt(context));
        return this.formula.calculate(level);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)LimaCoreLootRegistries.LEVEL_BASED_NUMBER_PROVIDER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.input.getReferencedContextParams();
    }
}

