/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Set;
import liedge.limacore.data.LimaEnumCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootContextUser;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface LootPositionSource
extends LootContextUser {
    public static final Codec<LootPositionSource> CODEC = Type.CODEC.dispatch(LootPositionSource::getType, Type::getCodec);

    @Nullable
    public Vec3 get(LootContext var1);

    public Type getType();

    public static LootPositionSource constant(Vec3 pos) {
        return new Constant(pos);
    }

    public static LootPositionSource entityPos(LootContext.EntityTarget target) {
        return new EntityPos(target);
    }

    public record Constant(Vec3 pos) implements LootPositionSource
    {
        public static final MapCodec<Constant> CODEC = Vec3.CODEC.fieldOf("pos").xmap(Constant::new, Constant::pos);

        @Override
        @Nullable
        public Vec3 get(LootContext context) {
            return this.pos;
        }

        @Override
        public Type getType() {
            return Type.CONSTANT;
        }
    }

    public record EntityPos(LootContext.EntityTarget target) implements LootPositionSource
    {
        public static final MapCodec<EntityPos> CODEC = LootContext.EntityTarget.CODEC.fieldOf("target").xmap(EntityPos::new, EntityPos::target);

        @Override
        @Nullable
        public Vec3 get(LootContext context) {
            Entity entity = (Entity)context.getParamOrNull(this.target.getParam());
            return entity != null ? entity.position() : null;
        }

        @Override
        public Type getType() {
            return Type.ENTITY_POS;
        }

        public Set<LootContextParam<?>> getReferencedContextParams() {
            return Set.of(this.target.getParam());
        }
    }

    public static enum Type implements StringRepresentable
    {
        CONSTANT("constant", Constant.CODEC),
        ENTITY_POS("entity", EntityPos.CODEC);

        public static final LimaEnumCodec<Type> CODEC;
        private final String name;
        private final MapCodec<? extends LootPositionSource> codec;

        private Type(String name, MapCodec<? extends LootPositionSource> codec) {
            this.name = name;
            this.codec = codec;
        }

        public MapCodec<? extends LootPositionSource> getCodec() {
            return this.codec;
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = LimaEnumCodec.create(Type.class);
        }
    }
}

