/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.world.loot.number;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import liedge.limacore.lib.math.LimaCoreMath;
import liedge.limacore.lib.math.LimaRoundingMode;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record RoundingNumberProvider(NumberProvider child, LimaRoundingMode mode) implements NumberProvider
{
    public static final MapCodec<RoundingNumberProvider> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)NumberProviders.CODEC.fieldOf("child").forGetter(RoundingNumberProvider::child), (App)LimaRoundingMode.CODEC.optionalFieldOf("mode", (Object)LimaRoundingMode.NATURAL).forGetter(RoundingNumberProvider::mode)).apply((Applicative)instance, RoundingNumberProvider::new));

    public static NumberProvider of(NumberProvider child, LimaRoundingMode mode) {
        return new RoundingNumberProvider(child, mode);
    }

    public float getFloat(LootContext context) {
        return this.getInt(context);
    }

    public int getInt(LootContext context) {
        return LimaCoreMath.round(this.child.getFloat(context), this.mode);
    }

    public LootNumberProviderType getType() {
        return (LootNumberProviderType)LimaCoreLootRegistries.ROUNDING_NUMBER_PROVIDER.get();
    }

    public Set<LootContextParam<?>> getReferencedContextParams() {
        return this.child.getReferencedContextParams();
    }
}

