#if ! defined INCLUDE_DH_WATER_FSH_7EFB
#define INCLUDE_DH_WATER_FSH_7EFB

#include "/lib/settings.glsl"
#include "/core/math.glsl"
#include "/lib/utils.glsl"
#include "/lib/gbuffers_basics.glsl"
#include "/core/transform.glsl"
#include "/lib/dh.glsl"
#include "/lib/time.glsl"

#include "/core/dh/uniforms.glsl"
#include "/core/dh/transform.glsl"
#if ! defined INCLUDE_UNIFORM_vec2_screenSize
#define INCLUDE_UNIFORM_vec2_screenSize
uniform vec2 screenSize; 
#endif

#if ! defined INCLUDE_UNIFORM_vec2_screenSizeInverse
#define INCLUDE_UNIFORM_vec2_screenSizeInverse
uniform vec2 screenSizeInverse; 
#endif
#include "/lib/lightmap.glsl"
#if ! defined INCLUDE_UNIFORM_sampler2D_depthtex0
#define INCLUDE_UNIFORM_sampler2D_depthtex0
uniform sampler2D depthtex0; 
#endif

#if ! defined INCLUDE_UNIFORM_float_near
#define INCLUDE_UNIFORM_float_near
uniform float near; 
#endif

#if ! defined INCLUDE_UNIFORM_float_far
#define INCLUDE_UNIFORM_float_far
uniform float far; 
#endif

#if ! defined INCLUDE_UNIFORM_sampler2D_colortex4
#define INCLUDE_UNIFORM_sampler2D_colortex4
uniform sampler2D colortex4; 
#endif

#if ! defined INCLUDE_UNIFORM_float_customLightmapBlend
#define INCLUDE_UNIFORM_float_customLightmapBlend
uniform float customLightmapBlend; 
#endif
#if FOG != 0
#if ! defined INCLUDE_UNIFORM_ivec2_eyeBrightnessSmooth
#define INCLUDE_UNIFORM_ivec2_eyeBrightnessSmooth
uniform ivec2 eyeBrightnessSmooth; 
#endif
#include "/lib/sky.glsl"
#endif

in vec2 lmcoord;
in vec2 coord;
flat in vec4 glcolor;
in vec3 viewPos;
flat in int materialId;

/* DRAWBUFFERS:0 */
layout(location = 0) out vec4 FragOut0;
void main() {
    vec3 playerPos = toPlayer(viewPos);
    vec3 worldPos  = toWorld(playerPos);

    // Discarding Logic
    
#ifdef DH_TRANSPARENT_DISCARD
#ifdef DH_DISCARD_SMOOTH
	float playerDist      = sqmag(playerPos);
	float playerDistBlend = smoothstep(sq(far * .6 - DH_TRANSPARENT_DISCARD_TOLERANCE), sq(far * .8 - DH_TRANSPARENT_DISCARD_TOLERANCE), playerDist);
    if ( playerDistBlend <= Bayer4(gl_FragCoord.xy) ) {
        discard;
    }
#else
    float borderTolerance = (materialId == DH_BLOCK_WATER ? 0 : 1e-5) + DH_TRANSPARENT_DISCARD_TOLERANCE;
    if ( discardDH(worldPos, borderTolerance) ) {
        discard;
    }
#endif
#endif

    float depth         = texelFetch(depthtex0, ivec2(gl_FragCoord.xy), 0).x;
    float dhDepth       = gl_FragCoord.z;
    vec3  dhScreenPos   = vec3(gl_FragCoord.xy * screenSizeInverse, dhDepth);
    vec3  dhViewPos     = screenToViewDH(dhScreenPos);
    float dhMappedDepth = backToScreen(dhViewPos).z;

    if (depth < 1 && depth < dhMappedDepth) {
        discard;
    }
    
    vec4 color = glcolor;

    if (materialId == DH_BLOCK_WATER) {
        vec2  waterTextureSize   = vec2(textureSize(colortex4, 0));
        float waterTextureAspect = waterTextureSize.x / waterTextureSize.y;
        vec2  blockCoords        = fract(worldPos.xz);
        vec2  waterCoords        = vec2(blockCoords.x, blockCoords.y * waterTextureAspect);
        waterCoords.y           += waterTextureAspect * floor(time * 10);

        float texelDensity = max(
            length(dFdx(worldPos.xz)),
            length(dFdy(worldPos.xz))
        ) * minc(waterTextureSize);
        float textureBlend = saturate(texelDensity * 0.5 - 1);
        vec4  waterTexture = texture(colortex4, waterCoords);
        vec4  waterColor   = waterTexture * vec4(glcolor.rgb * 1.5, 1);

        color = mix(waterColor, color, textureBlend);
    }

	color.rgb *= getCustomLightmap(vec3(lmcoord, 1), customLightmapBlend);

	#if FOG != 0

		vec3 viewDir = normalize(viewPos);
        vec3 playerDir;
        #if defined END 
        playerDir = normalize(playerPos);
        #endif

		float fog = fogFactorTerrain(playerPos);
        
        #ifdef FOG_ADVANCED
        float fa = fogFactorAdvanced(viewDir, playerPos);
        fog      = max(fog, fa);
        #endif

		#ifdef OVERWORLD
			float cave = max( saturate(eyeBrightnessSmooth.y * (4./240.) - 0.25), saturate(lmcoord.y * 1.5 - 0.25) );
		    cave       = saturate( cave + float(cameraPosition.y > 512) );
		#else
			float cave = 1;
		#endif

        color.rgb = mix(color.rgb, mix(fogCaveColor, getFogSkyColor(viewDir, playerDir), cave), fog);

	#endif

    FragOut0 = color;
}

#endif