/*
 * Decompiled with CFR 0.152.
 */
package io.github.jedlimlx.supplemental_patches.shaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.jedlimlx.supplemental_patches.shaders.MinecraftError;
import io.github.jedlimlx.supplemental_patches.shaders.ShaderResourceLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001d\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006\"\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lnet/minecraft/class_2960;", "location", "Lnet/minecraft/class_3300;", "manager", "Lcom/google/gson/JsonObject;", "loadJson", "(Lnet/minecraft/class_2960;Lnet/minecraft/class_3300;)Lcom/google/gson/JsonObject;", "Lcom/google/gson/Gson;", "GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "supplemental_patches"})
public final class ShaderResourceLoaderKt {
    @NotNull
    private static final Gson GSON;

    @NotNull
    public static final Gson getGSON() {
        return GSON;
    }

    @NotNull
    public static final JsonObject loadJson(@NotNull class_2960 location, @NotNull class_3300 manager) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        try {
            Object object = class_3518.method_15284((Gson)GSON, (String)ShaderResourceLoader.INSTANCE.getFileContents(location, manager), JsonObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (JsonObject)object;
        }
        catch (JsonParseException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Error parsing JSON file";
            }
            throw new MinecraftError(string, location.toString(), null, 4, null);
        }
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }
}

