/*
 * Decompiled with CFR 0.152.
 */
package io.github.jedlimlx.supplemental_patches.shaders;

import io.github.jedlimlx.supplemental_patches.shaders.Atmospherics;
import io.github.jedlimlx.supplemental_patches.shaders.UtilKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\u001a\u0015\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004\"\u001d\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0014\u0010\f\u001a\u00020\u000b8\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Ljava/nio/file/Path;", "directory", "", "generateAtmospherics", "(Ljava/nio/file/Path;)V", "", "Lio/github/jedlimlx/supplemental_patches/shaders/Atmospherics;", "ATMOSPHERICS", "Ljava/util/List;", "getATMOSPHERICS", "()Ljava/util/List;", "", "COMPOSITE_PATH", "Ljava/lang/String;", "supplemental_patches"})
@SourceDebugExtension(value={"SMAP\nAtmospherics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Atmospherics.kt\nio/github/jedlimlx/supplemental_patches/shaders/AtmosphericsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1869#2,2:64\n1869#2,2:66\n1869#2,2:68\n*S KotlinDebug\n*F\n+ 1 Atmospherics.kt\nio/github/jedlimlx/supplemental_patches/shaders/AtmosphericsKt\n*L\n16#1:64,2\n26#1:66,2\n48#1:68,2\n*E\n"})
public final class AtmosphericsKt {
    @NotNull
    private static final List<Atmospherics> ATMOSPHERICS = new ArrayList();
    @NotNull
    public static final String COMPOSITE_PATH = "/shaders/program/composite1.glsl";

    @NotNull
    public static final List<Atmospherics> getATMOSPHERICS() {
        return ATMOSPHERICS;
    }

    public static final void generateAtmospherics(@NotNull Path directory) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        File file = new File(((Object)directory.toAbsolutePath()).toString() + COMPOSITE_PATH);
        StringBuilder $this$generateAtmospherics_u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        String indent = "    ";
        Iterable $this$forEach$iv = ATMOSPHERICS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Atmospherics it = (Atmospherics)element$iv;
            boolean bl2 = false;
            $this$generateAtmospherics_u24lambda_u240.append(indent + "#if " + UtilKt.conditions(it.getConditions()) + "\n");
            $this$generateAtmospherics_u24lambda_u240.append(StringsKt.prependIndent((String)it.getMainCode(), (String)StringsKt.repeat((CharSequence)indent, (int)2)) + "\n");
            $this$generateAtmospherics_u24lambda_u240.append(indent + "#endif\n");
            $this$generateAtmospherics_u24lambda_u240.append("\n");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String compositeCode = string;
        StringBuilder $this$generateAtmospherics_u24lambda_u241 = $this$generateAtmospherics_u24lambda_u240 = new StringBuilder();
        boolean bl3 = false;
        String indent2 = "    ";
        Iterable $this$forEach$iv2 = ATMOSPHERICS;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            Atmospherics it = (Atmospherics)element$iv;
            boolean bl4 = false;
            $this$generateAtmospherics_u24lambda_u241.append("#if " + UtilKt.conditions(it.getConditions()) + "\n");
            $this$generateAtmospherics_u24lambda_u241.append(indent2 + "#include \"/lib/atmospherics/" + it.getLibPath() + "\"\n");
            $this$generateAtmospherics_u24lambda_u241.append("#endif\n");
            $this$generateAtmospherics_u24lambda_u241.append("\n");
        }
        String string2 = $this$generateAtmospherics_u24lambda_u240.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String compositeIncludes = string2;
        FilesKt.writeText$default((File)file, (String)StringsKt.replace$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)"    if (isEyeInWater == 1) {", (String)(compositeCode + "\n    if (isEyeInWater == 1) {"), (boolean)false, (int)4, null), null, (int)2, null);
        FilesKt.writeText$default((File)file, (String)StringsKt.replaceFirst$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)"//Includes//", (String)("//Includes//\n" + compositeIncludes), (boolean)false, (int)4, null), null, (int)2, null);
        Iterable $this$forEach$iv3 = ATMOSPHERICS;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv3) {
            Atmospherics it = (Atmospherics)element$iv;
            boolean bl5 = false;
            File file2 = new File(((Object)directory.toAbsolutePath()).toString() + "/shaders/lib/atmospherics/" + it.getLibPath());
            FilesKt.writeText$default((File)file2, (String)it.getLibCode(), null, (int)2, null);
        }
        String conditions = CollectionsKt.joinToString$default((Iterable)ATMOSPHERICS, (CharSequence)" || ", null, null, (int)0, null, AtmosphericsKt::generateAtmospherics$lambda$3, (int)30, null);
        if (((CharSequence)conditions).length() > 0) {
            FilesKt.writeText$default((File)file, (String)StringsKt.replace$default((String)FilesKt.readText$default((File)file, null, (int)1, null), (String)"defined NETHER_STORM || defined COLORED_LIGHT_FOG", (String)(conditions + " || defined NETHER_STORM || defined COLORED_LIGHT_FOG"), (boolean)false, (int)4, null), null, (int)2, null);
        }
    }

    private static final CharSequence generateAtmospherics$lambda$3(Atmospherics it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + UtilKt.conditions(it.getConditions()) + ")";
    }
}

