/*
 * Decompiled with CFR 0.152.
 */
package io.github.jedlimlx.supplemental_patches.shaders;

import io.github.jedlimlx.supplemental_patches.SupplementalPatches;
import io.github.jedlimlx.supplemental_patches.shaders.AtmosphericsKt;
import io.github.jedlimlx.supplemental_patches.shaders.BufferKt;
import io.github.jedlimlx.supplemental_patches.shaders.DeferredMaterialKt;
import io.github.jedlimlx.supplemental_patches.shaders.MaterialGeneratorKt;
import io.github.jedlimlx.supplemental_patches.shaders.RefactorsKt;
import io.github.jedlimlx.supplemental_patches.shaders.SettingsKt;
import io.github.jedlimlx.supplemental_patches.shaders.ShaderMixinKt;
import io.github.jedlimlx.supplemental_patches.shaders.SkyKt;
import io.github.jedlimlx.supplemental_patches.shaders.SpecificMaterialKt;
import io.github.jedlimlx.supplemental_patches.shaders.TextureKt;
import io.github.jedlimlx.supplemental_patches.shaders.UniformKt;
import io.github.jedlimlx.supplemental_patches.shaders.UtilKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\r\u0010\u0001\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0001\u0010\u0002\u001a\u000f\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\"\u0017\u0010\u0006\u001a\u00020\u00038\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\u0005\u00a8\u0006\t"}, d2={"", "installShader", "()Ljava/lang/String;", "Ljava/nio/file/Path;", "detectInstallation", "()Ljava/nio/file/Path;", "SHADERS_DIRECTORY", "Ljava/nio/file/Path;", "getSHADERS_DIRECTORY", "supplemental_patches"})
@SourceDebugExtension(value={"SMAP\nShaderInstaller.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderInstaller.kt\nio/github/jedlimlx/supplemental_patches/shaders/ShaderInstallerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n295#2,2:67\n*S KotlinDebug\n*F\n+ 1 ShaderInstaller.kt\nio/github/jedlimlx/supplemental_patches/shaders/ShaderInstallerKt\n*L\n61#1:67,2\n*E\n"})
public final class ShaderInstallerKt {
    @NotNull
    private static final Path SHADERS_DIRECTORY;

    @NotNull
    public static final Path getSHADERS_DIRECTORY() {
        return SHADERS_DIRECTORY;
    }

    @NotNull
    public static final String installShader() {
        return (String)UtilKt.catchAndPrintError(ShaderInstallerKt::installShader$lambda$0);
    }

    @Nullable
    public static final Path detectInstallation() {
        Object v2;
        block1: {
            Iterable $this$firstOrNull$iv = PathsKt.listDirectoryEntries$default((Path)SHADERS_DIRECTORY, null, (int)1, null);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                CharSequence charSequence;
                Path it = (Path)element$iv;
                boolean bl = false;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                boolean bl2 = Files.isDirectory(it, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) && new Regex("Complementary(Unbound|Reimagined)_r(\\d+.?)+ \\+ EuphoriaPatches_(\\d+.?)+").matches(charSequence = (CharSequence)PathsKt.getName((Path)it));
                if (!bl2) continue;
                v2 = element$iv;
                break block1;
            }
            v2 = null;
        }
        return v2;
    }

    private static final String installShader$lambda$0() {
        Path installation = ShaderInstallerKt.detectInstallation();
        if (installation == null) {
            SupplementalPatches.LOGGER.warn("No Complementary Shaders + Euphoria Patches installation detected.");
            return "No Complementary Shaders + Euphoria Patches installation detected.";
        }
        SupplementalPatches.LOGGER.info("Detected shader installation at " + installation + ".");
        Path path = Paths.get(SHADERS_DIRECTORY + "/" + PathsKt.getName((Path)installation) + " + Supplemental Patches", new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path newInstallation = path;
        PathsKt.deleteRecursively((Path)newInstallation);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectory(newInstallation, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectory(...)");
        PathsKt.copyToRecursively$default((Path)installation, (Path)newInstallation, null, (boolean)false, (boolean)true, (int)2, null);
        SupplementalPatches.LOGGER.info("Duplicated shader installation to " + newInstallation + ".");
        MaterialGeneratorKt.modifyBlockProperties(newInstallation);
        MaterialGeneratorKt.modifyEntityProperties(newInstallation);
        MaterialGeneratorKt.modifyItemProperties(newInstallation);
        DeferredMaterialKt.generatedDeferredMaterials(newInstallation);
        SpecificMaterialKt.generateSpecificMaterials(newInstallation);
        MaterialGeneratorKt.assignVoxelNumbers();
        MaterialGeneratorKt.generateTerrainMaterials(newInstallation);
        MaterialGeneratorKt.generateEntityMaterials(newInstallation);
        MaterialGeneratorKt.generateIrisMaterials(newInstallation);
        MaterialGeneratorKt.generateTranslucentMaterials(newInstallation);
        MaterialGeneratorKt.generateBlockEntityMaterials(newInstallation);
        MaterialGeneratorKt.generateVoxelsAndBlocklight(newInstallation);
        MaterialGeneratorKt.generateWavingCode(newInstallation);
        MaterialGeneratorKt.generateReflectionHanders(newInstallation);
        MaterialGeneratorKt.generateParticleCode(newInstallation);
        BufferKt.injectBuffers(newInstallation);
        UniformKt.generateUniforms(newInstallation);
        MaterialGeneratorKt.generateFog(newInstallation);
        SkyKt.generateSkies(newInstallation);
        TextureKt.generateTextures(newInstallation);
        AtmosphericsKt.generateAtmospherics(newInstallation);
        SettingsKt.generateSettingsFiles(newInstallation);
        SettingsKt.generateSettings(newInstallation);
        RefactorsKt.refactorFunctions(newInstallation);
        ShaderMixinKt.generateShaderMixins(newInstallation);
        MaterialGeneratorKt.modifyLayers(newInstallation);
        MaterialGeneratorKt.modifyGBuffers(newInstallation);
        MaterialGeneratorKt.injectCommonFunctions(newInstallation);
        return "Shaders successfully installed at " + newInstallation + ".";
    }

    static {
        Path path = FabricLoader.getInstance().getGameDir().resolve("shaderpacks");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        SHADERS_DIRECTORY = path;
    }
}

