/*
 * Decompiled with CFR 0.152.
 */
package io.github.jedlimlx.supplemental_patches.mixins.uniforms;

import java.awt.Color;
import java.util.Optional;
import me.fallenbreath.conditionalmixin.api.annotation.Condition;
import me.fallenbreath.conditionalmixin.api.annotation.Restriction;
import net.bunten.enderscape.biome.util.SkyParameters;
import net.irisshaders.iris.gl.uniform.UniformHolder;
import net.irisshaders.iris.gl.uniform.UniformUpdateFrequency;
import net.irisshaders.iris.uniforms.BiomeUniforms;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.Holder;
import org.joml.Vector3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Restriction(require={@Condition(value="enderscape")})
@Mixin(value={BiomeUniforms.class}, remap=false)
public abstract class EnderscapeAtmosphereUniforms {
    private static Color getNebulaColor(LocalPlayer player) {
        Optional temp = SkyParameters.getSkyParametersFor((Holder)player.level().getBiome(player.blockPosition()));
        return temp.map(skyParameters -> new Color(skyParameters.nebulaColor())).orElse(new Color(8084382));
    }

    @Inject(method={"addBiomeUniforms"}, at={@At(value="TAIL")}, remap=false)
    private static void addBiomeUniforms(UniformHolder uniforms, CallbackInfo ci) {
        uniforms.uniform3f(UniformUpdateFrequency.PER_TICK, "enderscapeNebulaColor", () -> {
            LocalPlayer player = Minecraft.getInstance().player;
            Color color = player != null ? EnderscapeAtmosphereUniforms.getNebulaColor(player) : new Color(8084382);
            return new Vector3f((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue());
        }).uniform1f(UniformUpdateFrequency.PER_TICK, "enderscapeNebulaAlpha", () -> {
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                Optional temp = SkyParameters.getSkyParametersFor((Holder)player.level().getBiome(player.blockPosition()));
                return temp.map(SkyParameters::nebulaAlpha).orElse(Float.valueOf(0.05f)).floatValue();
            }
            return 0.05f;
        });
    }
}

