/*
 * Decompiled with CFR 0.152.
 */
package io.github.jedlimlx.supplemental_patches.shaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.jedlimlx.supplemental_patches.shaders.MinecraftError;
import io.github.jedlimlx.supplemental_patches.shaders.ShaderResourceLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"GSON", "Lcom/google/gson/Gson;", "getGSON", "()Lcom/google/gson/Gson;", "loadJson", "Lcom/google/gson/JsonObject;", "location", "Lnet/minecraft/resources/ResourceLocation;", "manager", "Lnet/minecraft/server/packs/resources/ResourceManager;", "supplemental_patches"})
public final class ShaderResourceLoaderKt {
    @NotNull
    private static final Gson GSON;

    @NotNull
    public static final Gson getGSON() {
        return GSON;
    }

    @NotNull
    public static final JsonObject loadJson(@NotNull ResourceLocation location, @NotNull ResourceManager manager) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        try {
            Object object = GsonHelper.fromJson((Gson)GSON, (String)ShaderResourceLoader.INSTANCE.getFileContents(location, manager), JsonObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (JsonObject)object;
        }
        catch (JsonParseException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Error parsing JSON file";
            }
            throw new MinecraftError(string, location.toString(), null, 4, null);
        }
    }

    static {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        GSON = gson;
    }
}

