/*
 * Decompiled with CFR 0.152.
 */
package io.github.jedlimlx.supplemental_patches.shaders;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\u000f\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\u0015\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0012J\r\u0010\u0014\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\"\u0010\u0003\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u0017\"\u0004\b\u001a\u0010\u001bR\"\u0010\u0004\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0004\u0010\u0018\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u001bR\"\u0010\u0005\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u001e\u0010\u0017\"\u0004\b\u001f\u0010\u001bR\"\u0010\u0006\u001a\u00020\u00028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0018\u001a\u0004\b \u0010\u0017\"\u0004\b!\u0010\u001bR\u0017\u0010\b\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006%"}, d2={"Lio/github/jedlimlx/supplemental_patches/shaders/Rectangle;", "", "", "x1", "y1", "x2", "y2", "", "glsl", "<init>", "(IIIILjava/lang/String;)V", "rectangle", "", "canMergeX", "(Lio/github/jedlimlx/supplemental_patches/shaders/Rectangle;)Z", "canMergeY", "", "mergeX", "(Lio/github/jedlimlx/supplemental_patches/shaders/Rectangle;)V", "mergeY", "copy", "()Lio/github/jedlimlx/supplemental_patches/shaders/Rectangle;", "hashCode", "()I", "I", "getX1", "setX1", "(I)V", "getY1", "setY1", "getX2", "setX2", "getY2", "setY2", "Ljava/lang/String;", "getGlsl", "()Ljava/lang/String;", "supplemental_patches"})
public final class Rectangle {
    private int x1;
    private int y1;
    private int x2;
    private int y2;
    @NotNull
    private final String glsl;

    public Rectangle(int x1, int y1, int x2, int y2, @NotNull String glsl) {
        Intrinsics.checkNotNullParameter((Object)glsl, (String)"glsl");
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.glsl = glsl;
    }

    public final int getX1() {
        return this.x1;
    }

    public final void setX1(int n) {
        this.x1 = n;
    }

    public final int getY1() {
        return this.y1;
    }

    public final void setY1(int n) {
        this.y1 = n;
    }

    public final int getX2() {
        return this.x2;
    }

    public final void setX2(int n) {
        this.x2 = n;
    }

    public final int getY2() {
        return this.y2;
    }

    public final void setY2(int n) {
        this.y2 = n;
    }

    @NotNull
    public final String getGlsl() {
        return this.glsl;
    }

    public final boolean canMergeX(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        return this.x1 == rectangle.x1 && this.x2 == rectangle.x2 && (this.y1 == rectangle.y2 + 1 || this.y2 + 1 == rectangle.y1);
    }

    public final boolean canMergeY(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        return this.y1 == rectangle.y1 && this.y2 == rectangle.y2 && (this.x1 == rectangle.x2 + 1 || this.x2 + 1 == rectangle.x1);
    }

    public final void mergeX(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.y1 = Math.min(this.y1, rectangle.y1);
        this.y2 = Math.max(this.y2, rectangle.y2);
    }

    public final void mergeY(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.x1 = Math.min(this.x1, rectangle.x1);
        this.x2 = Math.max(this.x2, rectangle.x2);
    }

    @NotNull
    public final Rectangle copy() {
        return new Rectangle(this.x1, this.y1, this.x2, this.y2, this.glsl);
    }

    public int hashCode() {
        return this.glsl.hashCode();
    }
}

