/*
 * Decompiled with CFR 0.152.
 */
package com.treflea4.betterhappyghasts.mixin;

import com.treflea4.betterhappyghasts.entity.BoostableEntity;
import com.treflea4.betterhappyghasts.entity.Witherable;
import com.treflea4.betterhappyghasts.goal.DropSorrowTearGoal;
import com.treflea4.betterhappyghasts.item.ModItems;
import com.treflea4.betterhappyghasts.networking.packet.BoostEffectS2C;
import com.treflea4.betterhappyghasts.sound.ModSounds;
import java.util.List;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11187;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2387;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2619;
import net.minecraft.class_2680;
import net.minecraft.class_2748;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_6880;
import net.minecraft.class_8710;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_11187.class})
public abstract class HappyGhastEntityMixin
extends class_1429
implements Witherable,
BoostableEntity {
    @Unique
    private static final class_2940<Boolean> IS_WITHERED = class_2945.method_12791(class_11187.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Boolean> IS_BOOSTING = class_2945.method_12791(class_11187.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Integer> BOOST_TIMER = class_2945.method_12791(class_11187.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final class_2940<Integer> BOOST_COOLDOWN = class_2945.method_12791(class_11187.class, (class_2941)class_2943.field_13327);
    @Unique
    private static final int MAX_COOLDOWN = 100;
    @Unique
    private static final int BOOST_DURATION = 60;
    @Unique
    private static final double BOOST_MULTIPLIER = 1.6;
    @Unique
    private static final int WITHER_EFFECT_RADIUS = 7;
    @Unique
    private double originalSpeed = 0.0;
    @Unique
    private class_3222 lastRider;
    @Unique
    private boolean wasOnCooldown = false;
    @Unique
    private int witherCheckCooldown = 0;
    @Unique
    private boolean totemGlintActive = false;
    @Unique
    private static final int JUKEBOX_SEARCH_RADIUS = 32;
    @Unique
    private class_2338 targetJukeboxPos = null;
    @Unique
    private int jukeboxCheckCooldown = 0;

    protected HappyGhastEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initGoals"}, at={@At(value="TAIL")})
    private void addCustomGoal(CallbackInfo ci) {
        class_11187 happyGhast = (class_11187)this;
        this.field_6201.method_6277(5, (class_1352)new DropSorrowTearGoal(happyGhast));
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void addCustomTrackers(class_2945.class_9222 builder, CallbackInfo ci) {
        builder.method_56912(IS_WITHERED, (Object)false);
        builder.method_56912(IS_BOOSTING, (Object)false);
        builder.method_56912(BOOST_TIMER, (Object)0);
        builder.method_56912(BOOST_COOLDOWN, (Object)0);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void onTick(CallbackInfo ci) {
        if (this.method_37908().field_9236) {
            return;
        }
        if (--this.witherCheckCooldown <= 0) {
            this.witherCheckCooldown = 20;
            boolean witherNearby = this.isWitherRoseNearbyInArea();
            if (this.isWithered$better_happy_ghasts() != witherNearby) {
                this.setWithered$better_happy_ghasts(witherNearby);
            }
        }
        if (this.isWithered$better_happy_ghasts()) {
            List entities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1014(7.0), entity -> !(entity instanceof class_11187));
            for (class_1309 entity2 : entities) {
                HappyGhastEntityMixin.applyWitheredEffects(entity2);
            }
        }
        if (--this.jukeboxCheckCooldown <= 0) {
            this.jukeboxCheckCooldown = 200 + (this.method_5628() & 0x3F);
            this.findNearbyPlayingJukebox();
        }
        this.handleBoostLogic();
        this.handlePlayerDisconnection();
        this.handleJukeboxAttraction();
    }

    @Unique
    private boolean isWitherRoseNearbyInArea() {
        class_2338 center = this.method_24515();
        try (Stream stream = class_2338.method_20437((class_2338)center.method_10069(-7, -7, -7), (class_2338)center.method_10069(7, 7, 7));){
            boolean bl = stream.anyMatch(pos -> this.method_37908().method_8320(pos).method_27852(class_2246.field_10606));
            return bl;
        }
    }

    @Unique
    private static void applyWitheredEffects(class_1309 entity) {
        if (!entity.method_6059(class_1294.field_5909) || entity.method_6112(class_1294.field_5909).method_5584() < 40) {
            entity.method_6092(new class_1293(class_1294.field_5909, 80, 2, false, false));
        }
        if (!entity.method_6059(class_1294.field_5920) || entity.method_6112(class_1294.field_5920).method_5584() < 40) {
            entity.method_6092(new class_1293(class_1294.field_5920, 80, 0, false, false));
        }
    }

    @Unique
    private void handlePlayerDisconnection() {
        if (this.lastRider != null && this.lastRider.method_14239()) {
            if (((Boolean)this.field_6011.method_12789(IS_BOOSTING)).booleanValue()) {
                this.endBoost();
            } else if (this.originalSpeed > 0.0) {
                this.method_5996(class_5134.field_23720).method_6192(this.originalSpeed);
                this.originalSpeed = 0.0;
            }
            this.lastRider = null;
            this.wasOnCooldown = false;
        }
    }

    @Inject(method={"removePassenger"}, at={@At(value="HEAD")})
    private void onRemovePassenger(class_1297 passenger, CallbackInfo ci) {
        if (this.method_37908().field_9236 || !(passenger instanceof class_3222)) {
            return;
        }
        class_3222 player = (class_3222)passenger;
        if (((Boolean)this.field_6011.method_12789(IS_BOOSTING)).booleanValue()) {
            this.endBoost();
        } else if (this.originalSpeed > 0.0) {
            this.method_5996(class_5134.field_23720).method_6192(this.originalSpeed);
            this.originalSpeed = 0.0;
        }
        if (this.wasOnCooldown) {
            this.restoreExperienceBar(player);
            this.wasOnCooldown = false;
        }
        this.lastRider = null;
    }

    @Unique
    private void handleBoostLogic() {
        class_1309 controllingPassenger;
        int cooldown = (Integer)this.field_6011.method_12789(BOOST_COOLDOWN);
        boolean isBoosting = (Boolean)this.field_6011.method_12789(IS_BOOSTING);
        if (cooldown > 0) {
            this.field_6011.method_12778(BOOST_COOLDOWN, (Object)(--cooldown));
        }
        if ((controllingPassenger = this.method_5642()) instanceof class_3222) {
            class_3222 rider;
            this.lastRider = rider = (class_3222)controllingPassenger;
            if (cooldown > 0) {
                float cooldownProgress = (float)cooldown / 100.0f;
                rider.field_13987.method_14364((class_2596)new class_2748(cooldownProgress, 0, 0));
                this.wasOnCooldown = true;
            } else if (this.wasOnCooldown) {
                this.restoreExperienceBar(rider);
                this.wasOnCooldown = false;
            }
            if (isBoosting) {
                this.updateBoost();
            } else {
                this.handleTotemSpeedBoost();
            }
        } else if (isBoosting) {
            this.endBoost();
        }
    }

    @Unique
    private void updateBoost() {
        int boostTimer = (Integer)this.field_6011.method_12789(BOOST_TIMER);
        this.field_6011.method_12778(BOOST_TIMER, (Object)(--boostTimer));
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (boostTimer % 2 == 0) {
                class_243 pos = this.method_19538();
                serverWorld.method_65096((class_2394)class_2398.field_11204, pos.field_1352, pos.field_1351 - 1.0, pos.field_1350, 8, 0.6, 0.6, 0.6, 0.01);
            }
        }
        if (boostTimer <= 0) {
            this.endBoost();
        }
    }

    @Inject(method={"writeCustomData"}, at={@At(value="TAIL")})
    private void writeBoostData(class_11372 view, CallbackInfo ci) {
        view.method_71463("original_speed", this.originalSpeed);
        view.method_71472("is_boosting", ((Boolean)this.field_6011.method_12789(IS_BOOSTING)).booleanValue());
        view.method_71465("boost_timer", ((Integer)this.field_6011.method_12789(BOOST_TIMER)).intValue());
        view.method_71465("boost_cooldown", ((Integer)this.field_6011.method_12789(BOOST_COOLDOWN)).intValue());
    }

    @Inject(method={"readCustomData"}, at={@At(value="TAIL")})
    private void readBoostData(class_11368 view, CallbackInfo ci) {
        this.originalSpeed = view.method_71422("original_speed", 0.0);
        this.field_6011.method_12778(IS_BOOSTING, (Object)view.method_71433("is_boosting", false));
        this.field_6011.method_12778(BOOST_TIMER, (Object)view.method_71424("boost_timer", 0));
        this.field_6011.method_12778(BOOST_COOLDOWN, (Object)view.method_71424("boost_cooldown", 0));
    }

    @Override
    @Unique
    public void startBoost$better_happy_ghasts() {
        if ((Integer)this.field_6011.method_12789(BOOST_COOLDOWN) > 0 || ((Boolean)this.field_6011.method_12789(IS_BOOSTING)).booleanValue()) {
            return;
        }
        if (this.originalSpeed == 0.0) {
            this.originalSpeed = this.method_5996(class_5134.field_23720).method_6201();
        }
        this.field_6011.method_12778(IS_BOOSTING, (Object)true);
        this.field_6011.method_12778(BOOST_TIMER, (Object)60);
        class_1309 controllingPassenger = this.method_5642();
        double boostMultiplier = 1.6;
        if (controllingPassenger instanceof class_3222) {
            boolean hasTotem;
            class_3222 rider = (class_3222)controllingPassenger;
            class_1799 mainHand = rider.method_6047();
            class_1799 offHand = rider.method_6079();
            boolean bl = hasTotem = mainHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY) || offHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY);
            if (hasTotem) {
                boostMultiplier = 2.08;
                class_1799 totemStack = mainHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY) ? mainHand : offHand;
                totemStack.method_57379(class_9334.field_49641, (Object)true);
                class_3218 sw = rider.method_51469();
                sw.method_43129(null, (class_1297)rider, class_3417.field_15119, class_3419.field_15256, 1.0f, 0.5f);
                this.totemGlintActive = true;
            }
        }
        this.method_5996(class_5134.field_23720).method_6192(this.originalSpeed * boostMultiplier);
        if (controllingPassenger instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)controllingPassenger;
            this.method_37908().method_60511(null, this.method_23317(), this.method_23318(), this.method_23321(), (class_6880)class_3417.field_49044, class_3419.field_15256, 3.0f, 1.0f);
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new BoostEffectS2C(true));
        }
    }

    @Unique
    private void endBoost() {
        class_1309 controllingPassenger;
        this.field_6011.method_12778(IS_BOOSTING, (Object)false);
        this.field_6011.method_12778(BOOST_COOLDOWN, (Object)100);
        this.wasOnCooldown = true;
        if (this.totemGlintActive) {
            controllingPassenger = this.method_5642();
            if (controllingPassenger instanceof class_3222) {
                class_1799 totemStack;
                class_3222 rider = (class_3222)controllingPassenger;
                class_1799 mainHand = rider.method_6047();
                class_1799 offHand = rider.method_6079();
                class_1799 class_17992 = mainHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY) ? mainHand : (totemStack = offHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY) ? offHand : class_1799.field_8037);
                if (!totemStack.method_7960()) {
                    totemStack.method_57379(class_9334.field_49641, (Object)false);
                }
            }
            this.totemGlintActive = false;
        }
        controllingPassenger = this.method_5642();
        boolean hasTotem = false;
        if (controllingPassenger instanceof class_3222) {
            class_3222 rider = (class_3222)controllingPassenger;
            class_1799 mainHand = rider.method_6047();
            class_1799 offHand = rider.method_6079();
            boolean bl = hasTotem = mainHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY) || offHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY);
        }
        if (this.originalSpeed > 0.0) {
            if (hasTotem) {
                this.method_5996(class_5134.field_23720).method_6192(this.originalSpeed * 1.5);
            } else {
                this.method_5996(class_5134.field_23720).method_6192(this.originalSpeed);
                this.originalSpeed = 0.0;
            }
        }
        if (controllingPassenger instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)controllingPassenger;
            ServerPlayNetworking.send((class_3222)serverPlayer, (class_8710)new BoostEffectS2C(false));
        } else if (this.lastRider != null) {
            ServerPlayNetworking.send((class_3222)this.lastRider, (class_8710)new BoostEffectS2C(false));
        }
    }

    @Unique
    private void restoreExperienceBar(class_3222 player) {
        if (player != null && player.field_13987 != null) {
            player.field_13987.method_14364((class_2596)new class_2748(player.field_7510, player.field_7495, player.field_7520));
        }
    }

    @Unique
    private void handleTotemSpeedBoost() {
        class_1309 controllingPassenger = this.method_5642();
        if (controllingPassenger instanceof class_3222) {
            double currentSpeed;
            boolean hasTotem;
            class_3222 rider = (class_3222)controllingPassenger;
            class_1799 mainHand = rider.method_6047();
            class_1799 offHand = rider.method_6079();
            boolean bl = hasTotem = mainHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY) || offHand.method_31574(ModItems.TOTEM_OF_THE_WEEPING_SKY);
            if (hasTotem) {
                if (this.originalSpeed == 0.0) {
                    this.originalSpeed = this.method_5996(class_5134.field_23720).method_6201();
                }
                double currentSpeed2 = this.method_5996(class_5134.field_23720).method_6201();
                double expectedTotemSpeed = this.originalSpeed * 1.5;
                if (!((Boolean)this.field_6011.method_12789(IS_BOOSTING)).booleanValue() && Math.abs(currentSpeed2 - expectedTotemSpeed) > 0.01) {
                    this.method_5996(class_5134.field_23720).method_6192(expectedTotemSpeed);
                }
            } else if (!((Boolean)this.field_6011.method_12789(IS_BOOSTING)).booleanValue() && this.originalSpeed > 0.0 && Math.abs((currentSpeed = this.method_5996(class_5134.field_23720).method_6201()) - this.originalSpeed) > 0.01) {
                this.method_5996(class_5134.field_23720).method_6192(this.originalSpeed);
            }
        }
    }

    @Unique
    private void findNearbyPlayingJukebox() {
        double currentDistance;
        class_1937 world = this.method_37908();
        class_2338 center = this.method_24515();
        int cx = center.method_10263();
        int cy = center.method_10264();
        int cz = center.method_10260();
        class_2338 closestJukebox = null;
        double closestDistance = Double.MAX_VALUE;
        if (this.targetJukeboxPos != null && (currentDistance = center.method_10262((class_2382)this.targetJukeboxPos)) <= 64.0) {
            return;
        }
        class_2338.class_2339 mpos = new class_2338.class_2339();
        for (int radius = 1; radius <= 32; ++radius) {
            boolean foundInThisRadius = false;
            int yMin = -Math.min(radius, 16);
            int yMax = Math.min(radius, 16);
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    if (Math.abs(x) < radius && Math.abs(z) < radius) continue;
                    for (int y = yMin; y <= yMax; ++y) {
                        double dist;
                        class_2619 jukebox;
                        class_1799 recordStack;
                        class_2586 be;
                        mpos.method_10103(cx + x, cy + y, cz + z);
                        class_2680 state = world.method_8320((class_2338)mpos);
                        if (!state.method_27852(class_2246.field_10223) || state.method_28498((class_2769)class_2387.field_11180) && !((Boolean)state.method_11654((class_2769)class_2387.field_11180)).booleanValue() || !((be = world.method_8321((class_2338)mpos)) instanceof class_2619) || (recordStack = (jukebox = (class_2619)be).method_54079()).method_7960() || jukebox.method_60784().method_60759() == null || !recordStack.method_31574(class_1802.field_60667) || !((dist = (double)(x * x + y * y + z * z)) < closestDistance)) continue;
                        closestDistance = dist;
                        closestJukebox = mpos.method_10062();
                        foundInThisRadius = true;
                    }
                }
            }
            if (foundInThisRadius) break;
        }
        this.targetJukeboxPos = closestJukebox;
    }

    @Unique
    private void handleJukeboxAttraction() {
        if (this.targetJukeboxPos == null) {
            return;
        }
        if (!this.method_37908().method_8320(this.targetJukeboxPos).method_27852(class_2246.field_10223)) {
            this.targetJukeboxPos = null;
            return;
        }
        class_2586 class_25862 = this.method_37908().method_8321(this.targetJukeboxPos);
        if (!(class_25862 instanceof class_2619)) {
            this.targetJukeboxPos = null;
            return;
        }
        class_2619 jukebox = (class_2619)class_25862;
        if (jukebox.method_54079().method_7960() || jukebox.method_60784().method_60759() == null) {
            this.targetJukeboxPos = null;
            return;
        }
        if (this.isWithered$better_happy_ghasts()) {
            return;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            if (this.method_37908().method_8510() % 10L == 0L) {
                class_243 particlePos = this.method_19538().method_1031(0.0, (double)this.method_17682() + 0.5, 0.0);
                double randomValue = Math.random();
                serverWorld.method_65096((class_2394)class_2398.field_11224, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.3, 0.1, 0.3, randomValue);
            }
        }
        class_243 jukeboxPos = class_243.method_24953((class_2382)this.targetJukeboxPos);
        class_243 currentPos = this.method_19538();
        double distance = currentPos.method_1025(jukeboxPos);
        if (distance < 25.0) {
            double randomValue = Math.random();
            class_1937 class_19373 = this.method_37908();
            if (class_19373 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19373;
                if (this.method_37908().method_8510() % 5L == 0L) {
                    class_243 particlePos = this.method_19538().method_1031(0.0, (double)this.method_17682() + 0.5, 0.0);
                    serverWorld.method_65096((class_2394)class_2398.field_11224, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 2, 0.5, 0.2, 0.5, randomValue);
                }
            }
            float time = (float)this.method_37908().method_8510() * 0.02f;
            double circleRadius = 3.0;
            double targetX = jukeboxPos.field_1352 + Math.cos(time) * circleRadius;
            double targetZ = jukeboxPos.field_1350 + Math.sin(time) * circleRadius;
            double targetY = jukeboxPos.field_1351 + 2.0;
            class_243 targetPos = new class_243(targetX, targetY, targetZ);
            class_243 direction = targetPos.method_1020(currentPos).method_1029();
            double speed = this.method_5782() ? 0.03 : 0.08;
            this.method_18799(direction.method_1021(speed));
            return;
        }
        class_243 direction = jukeboxPos.method_1020(currentPos).method_1029();
        double speed = 0.1;
        if (this.method_5782()) {
            class_243 currentVelocity = this.method_18798();
            class_243 attractionForce = direction.method_1021(speed *= 0.3);
            this.method_18799(currentVelocity.method_1019(attractionForce.method_1021(0.1)));
        } else {
            this.method_18799(direction.method_1021(speed));
        }
    }

    @Override
    @Unique
    public void setWithered$better_happy_ghasts(boolean withered) {
        this.field_6011.method_12778(IS_WITHERED, (Object)withered);
    }

    @Override
    @Unique
    public boolean isWithered$better_happy_ghasts() {
        return (Boolean)this.field_6011.method_12789(IS_WITHERED);
    }

    @Inject(method={"getAmbientSound"}, at={@At(value="HEAD")}, cancellable=true)
    private void getWitheredAmbientSound(CallbackInfoReturnable<class_3414> cir) {
        if (this.isWithered$better_happy_ghasts()) {
            cir.setReturnValue((Object)ModSounds.WITHERED_HAPPY_GHAST_AMBIENT);
        }
    }

    @Inject(method={"getSoundPitch"}, at={@At(value="HEAD")}, cancellable=true)
    private void getWitheredSoundPitch(CallbackInfoReturnable<Float> cir) {
        if (this.isWithered$better_happy_ghasts()) {
            cir.setReturnValue((Object)Float.valueOf(0.7f));
        }
    }
}

