/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs;

import com.pallux.simplejobs.commands.JobsCommand;
import com.pallux.simplejobs.commands.SimpleJobsCommand;
import com.pallux.simplejobs.listeners.BlockBreakListener;
import com.pallux.simplejobs.listeners.BlockPlaceListener;
import com.pallux.simplejobs.listeners.EntityDeathListener;
import com.pallux.simplejobs.listeners.GUIListener;
import com.pallux.simplejobs.listeners.PlayerFishListener;
import com.pallux.simplejobs.managers.AntiAbuseManager;
import com.pallux.simplejobs.managers.ConfigManager;
import com.pallux.simplejobs.managers.GUIManager;
import com.pallux.simplejobs.managers.JobManager;
import com.pallux.simplejobs.managers.MessageManager;
import com.pallux.simplejobs.managers.PlayerDataManager;
import com.pallux.simplejobs.placeholders.SimpleJobsPlaceholder;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;

public class SimpleJobs
extends JavaPlugin {
    private static SimpleJobs instance;
    private Economy economy;
    private ConfigManager configManager;
    private MessageManager messageManager;
    private JobManager jobManager;
    private PlayerDataManager playerDataManager;
    private GUIManager guiManager;
    private AntiAbuseManager antiAbuseManager;

    public void onEnable() {
        instance = this;
        if (!this.setupEconomy()) {
            this.getLogger().severe("Vault not found! Disabling plugin...");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.getLogger().info("Vault economy hooked successfully!");
        this.configManager = new ConfigManager(this);
        this.messageManager = new MessageManager(this);
        this.jobManager = new JobManager(this);
        this.playerDataManager = new PlayerDataManager(this);
        this.guiManager = new GUIManager(this);
        this.antiAbuseManager = new AntiAbuseManager(this);
        this.configManager.loadConfig();
        this.messageManager.loadMessages();
        this.jobManager.loadJobs();
        this.playerDataManager.loadPlayerData();
        this.getCommand("sj").setExecutor((CommandExecutor)new SimpleJobsCommand(this));
        this.getCommand("jobs").setExecutor((CommandExecutor)new JobsCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new BlockBreakListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new EntityDeathListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerFishListener(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new GUIListener(this), (Plugin)this);
        if (this.getServer().getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new SimpleJobsPlaceholder(this).register();
            this.getLogger().info("PlaceholderAPI hooked successfully!");
        }
        this.antiAbuseManager.startCleanupTask();
        this.getLogger().info("SimpleJobs has been enabled!");
    }

    public void onDisable() {
        if (this.playerDataManager != null) {
            this.playerDataManager.savePlayerData();
        }
        this.getLogger().info("SimpleJobs has been disabled!");
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public void reload() {
        this.configManager.loadConfig();
        this.messageManager.loadMessages();
        this.jobManager.loadJobs();
        this.playerDataManager.loadPlayerData();
    }

    public static SimpleJobs getInstance() {
        return instance;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public MessageManager getMessageManager() {
        return this.messageManager;
    }

    public JobManager getJobManager() {
        return this.jobManager;
    }

    public PlayerDataManager getPlayerDataManager() {
        return this.playerDataManager;
    }

    public GUIManager getGUIManager() {
        return this.guiManager;
    }

    public AntiAbuseManager getAntiAbuseManager() {
        return this.antiAbuseManager;
    }
}

