/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.commands;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.jobs.Job;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class JobsCommand
implements CommandExecutor,
TabCompleter {
    private final SimpleJobs plugin;

    public JobsCommand(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.plugin.getGUIManager().openMainJobsGUI(player);
            return true;
        }
        String jobId = args[0];
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            this.plugin.getMessageManager().sendInvalidJob(player, jobId);
            return true;
        }
        this.plugin.getGUIManager().openJobGUI(player, jobId, 0);
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            for (Job job : this.plugin.getJobManager().getAllJobs()) {
                completions.add(job.getId());
            }
        }
        return completions;
    }
}

