/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.commands;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import com.pallux.simplejobs.utils.ColorUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class SimpleJobsCommand
implements CommandExecutor,
TabCompleter {
    private final SimpleJobs plugin;

    public SimpleJobsCommand(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (args.length == 0) {
            sender.sendMessage(ColorUtils.colorize(this.plugin.getMessageManager().getMessage("usage-main")));
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "reload": {
                return this.handleReload(sender);
            }
            case "jobs": {
                return this.handleJobs(sender, args);
            }
            case "info": {
                return this.handleInfo(sender);
            }
        }
        sender.sendMessage(ColorUtils.colorize(this.plugin.getMessageManager().getMessage("usage-main")));
        return true;
    }

    private boolean handleReload(CommandSender sender) {
        if (!sender.hasPermission("simplejobs.admin.reload")) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("no-permission"));
            return true;
        }
        this.plugin.reload();
        sender.sendMessage(this.plugin.getMessageManager().getMessage("reload-success"));
        return true;
    }

    private boolean handleJobs(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 1) {
            this.plugin.getGUIManager().openMainJobsGUI(player);
            return true;
        }
        String action = args[1].toLowerCase();
        if (action.equalsIgnoreCase("join")) {
            if (args.length < 3) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("usage-join"));
                return true;
            }
            return this.handleJoinJob(player, args[2]);
        }
        if (action.equalsIgnoreCase("leave")) {
            if (args.length < 3) {
                player.sendMessage(this.plugin.getMessageManager().getMessage("usage-leave"));
                return true;
            }
            return this.handleLeaveJob(player, args[2]);
        }
        String jobId = args[1];
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            this.plugin.getMessageManager().sendInvalidJob(player, jobId);
            return true;
        }
        this.plugin.getGUIManager().openJobGUI(player, jobId, 0);
        return true;
    }

    private boolean handleJoinJob(Player player, String jobId) {
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            this.plugin.getMessageManager().sendInvalidJob(player, jobId);
            return true;
        }
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data.hasJob(jobId)) {
            this.plugin.getMessageManager().sendAlreadyInJob(player, job.getName());
            return true;
        }
        if (!this.plugin.getPlayerDataManager().canJoinJob(player)) {
            int max = this.plugin.getPlayerDataManager().getMaxJobs(player);
            this.plugin.getMessageManager().sendMaxJobsReached(player, data.getJobCount(), max);
            return true;
        }
        this.plugin.getPlayerDataManager().joinJob(player, jobId);
        this.plugin.getMessageManager().sendJobJoined(player, job.getName());
        return true;
    }

    private boolean handleLeaveJob(Player player, String jobId) {
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            this.plugin.getMessageManager().sendInvalidJob(player, jobId);
            return true;
        }
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (!data.hasJob(jobId)) {
            this.plugin.getMessageManager().sendNotInJob(player, job.getName());
            return true;
        }
        this.plugin.getPlayerDataManager().leaveJob(player, jobId);
        this.plugin.getMessageManager().sendJobLeft(player, job.getName());
        return true;
    }

    private boolean handleInfo(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessageManager().getMessage("player-only"));
            return true;
        }
        Player player = (Player)sender;
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data.getJobCount() == 0) {
            player.sendMessage(this.plugin.getMessageManager().getMessage("job-info-none"));
            return true;
        }
        player.sendMessage(this.plugin.getMessageManager().getMessage("job-info-header"));
        for (String jobId : data.getJobs()) {
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null) continue;
            double multiplier = this.plugin.getPlayerDataManager().getMultiplier(player);
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("job", job.getName());
            placeholders.put("multiplier", String.format("%.1f", multiplier));
            player.sendMessage(this.plugin.getMessageManager().getMessage("job-info-line", placeholders));
        }
        int maxJobs = this.plugin.getPlayerDataManager().getMaxJobs(player);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("current_jobs", String.valueOf(data.getJobCount()));
        placeholders.put("max_jobs", String.valueOf(maxJobs));
        player.sendMessage(this.plugin.getMessageManager().getMessage("job-info-footer", placeholders));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions;
        block3: {
            block4: {
                block2: {
                    completions = new ArrayList<String>();
                    if (args.length != 1) break block2;
                    completions.add("reload");
                    completions.add("jobs");
                    completions.add("info");
                    break block3;
                }
                if (args.length != 2 || !args[0].equalsIgnoreCase("jobs")) break block4;
                completions.add("join");
                completions.add("leave");
                for (Job job : this.plugin.getJobManager().getAllJobs()) {
                    completions.add(job.getId());
                }
                break block3;
            }
            if (args.length != 3 || !args[0].equalsIgnoreCase("jobs") || !args[1].equalsIgnoreCase("join") && !args[1].equalsIgnoreCase("leave")) break block3;
            for (Job job : this.plugin.getJobManager().getAllJobs()) {
                completions.add(job.getId());
            }
        }
        return completions;
    }
}

