/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.data;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class PlayerData {
    private final UUID uuid;
    private final List<String> jobs;

    public PlayerData(UUID uuid) {
        this.uuid = uuid;
        this.jobs = new ArrayList<String>();
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public List<String> getJobs() {
        return new ArrayList<String>(this.jobs);
    }

    public boolean hasJob(String jobId) {
        return this.jobs.contains(jobId.toLowerCase());
    }

    public void addJob(String jobId) {
        if (!this.hasJob(jobId)) {
            this.jobs.add(jobId.toLowerCase());
        }
    }

    public void removeJob(String jobId) {
        this.jobs.remove(jobId.toLowerCase());
    }

    public int getJobCount() {
        return this.jobs.size();
    }

    public void clearJobs() {
        this.jobs.clear();
    }
}

