/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.jobs;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;

public class Job {
    private final String id;
    private final String name;
    private final String shortName;
    private final Material icon;
    private final List<String> description;
    private final Map<Material, Double> blockPayments;
    private final Map<Material, Double> plantingPayments;
    private final Map<EntityType, Double> entityPayments;
    private final Map<Material, Double> fishingPayments;

    public Job(String id, String name, String shortName, Material icon, List<String> description) {
        this.id = id;
        this.name = name;
        this.shortName = shortName;
        this.icon = icon;
        this.description = description;
        this.blockPayments = new HashMap<Material, Double>();
        this.plantingPayments = new HashMap<Material, Double>();
        this.entityPayments = new HashMap<EntityType, Double>();
        this.fishingPayments = new HashMap<Material, Double>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public Material getIcon() {
        return this.icon;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public Map<Material, Double> getBlockPayments() {
        return this.blockPayments;
    }

    public Map<Material, Double> getPlantingPayments() {
        return this.plantingPayments;
    }

    public Map<EntityType, Double> getEntityPayments() {
        return this.entityPayments;
    }

    public Map<Material, Double> getFishingPayments() {
        return this.fishingPayments;
    }

    public void addBlockPayment(Material material, double amount) {
        this.blockPayments.put(material, amount);
    }

    public void addPlantingPayment(Material material, double amount) {
        this.plantingPayments.put(material, amount);
    }

    public void addEntityPayment(EntityType entityType, double amount) {
        this.entityPayments.put(entityType, amount);
    }

    public void addFishingPayment(Material material, double amount) {
        this.fishingPayments.put(material, amount);
    }

    public double getBlockPayment(Material material) {
        return this.blockPayments.getOrDefault(material, 0.0);
    }

    public double getPlantingPayment(Material material) {
        return this.plantingPayments.getOrDefault(material, 0.0);
    }

    public double getEntityPayment(EntityType entityType) {
        return this.entityPayments.getOrDefault(entityType, 0.0);
    }

    public double getFishingPayment(Material material) {
        return this.fishingPayments.getOrDefault(material, 0.0);
    }

    public boolean hasBlockPayment(Material material) {
        return this.blockPayments.containsKey(material);
    }

    public boolean hasPlantingPayment(Material material) {
        return this.plantingPayments.containsKey(material);
    }

    public boolean hasEntityPayment(EntityType entityType) {
        return this.entityPayments.containsKey(entityType);
    }

    public boolean hasFishingPayment(Material material) {
        return this.fishingPayments.containsKey(material);
    }
}

