/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.listeners;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;

public class BlockBreakListener
implements Listener {
    private final SimpleJobs plugin;

    public BlockBreakListener(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material material = block.getType();
        if (this.plugin.getAntiAbuseManager().isRecentlyPlaced(block)) {
            return;
        }
        this.plugin.getAntiAbuseManager().removeBlock(block);
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        for (String jobId : data.getJobs()) {
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null || !job.hasBlockPayment(material)) continue;
            double basePayment = job.getBlockPayment(material);
            double multiplier = this.plugin.getPlayerDataManager().getMultiplier(player);
            double finalPayment = basePayment * multiplier;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, finalPayment);
            String itemName = this.formatMaterialName(material.name());
            this.plugin.getMessageManager().sendPaymentReceived(player, job.getName(), itemName, finalPayment);
        }
    }

    private String formatMaterialName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }
}

