/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.listeners;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockPlaceEvent;

public class BlockPlaceListener
implements Listener {
    private final SimpleJobs plugin;

    public BlockPlaceListener(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Block block = event.getBlock();
        Material material = block.getType();
        this.plugin.getAntiAbuseManager().markBlockPlaced(block);
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        for (String jobId : data.getJobs()) {
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null || !job.hasPlantingPayment(material)) continue;
            double basePayment = job.getPlantingPayment(material);
            double multiplier = this.plugin.getPlayerDataManager().getMultiplier(player);
            double finalPayment = basePayment * multiplier;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, finalPayment);
            String itemName = this.formatMaterialName(material.name());
            this.plugin.getMessageManager().sendPaymentReceived(player, job.getName(), itemName, finalPayment);
        }
    }

    private String formatMaterialName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }
}

