/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.listeners;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDeathEvent;

public class EntityDeathListener
implements Listener {
    private final SimpleJobs plugin;

    public EntityDeathListener(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        Player killer = event.getEntity().getKiller();
        if (killer == null) {
            return;
        }
        EntityType entityType = event.getEntityType();
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(killer);
        for (String jobId : data.getJobs()) {
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null || !job.hasEntityPayment(entityType)) continue;
            double basePayment = job.getEntityPayment(entityType);
            double multiplier = this.plugin.getPlayerDataManager().getMultiplier(killer);
            double finalPayment = basePayment * multiplier;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)killer, finalPayment);
            String entityName = this.formatEntityName(entityType.name());
            this.plugin.getMessageManager().sendPaymentReceived(killer, job.getName(), entityName, finalPayment);
        }
    }

    private String formatEntityName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }
}

