/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.listeners;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import com.pallux.simplejobs.managers.ConfigManager;
import com.pallux.simplejobs.managers.GUIManager;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.plugin.Plugin;

public class GUIListener
implements Listener {
    private final SimpleJobs plugin;

    public GUIListener(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        InventoryHolder holder = event.getInventory().getHolder();
        if (!(holder instanceof GUIManager.GUIHolder)) {
            return;
        }
        event.setCancelled(true);
        if (event.getClickedInventory() == null) {
            return;
        }
        if (event.getCurrentItem() == null) {
            return;
        }
        if (event.getRawSlot() >= event.getView().getTopInventory().getSize()) {
            return;
        }
        GUIManager.GUIHolder guiHolder = (GUIManager.GUIHolder)holder;
        int slot = event.getSlot();
        try {
            if (guiHolder.getType() == GUIManager.GUIType.MAIN_MENU) {
                this.handleMainMenuClick(player, slot);
            } else if (guiHolder.getType() == GUIManager.GUIType.JOB_MENU) {
                this.handleJobMenuClick(player, slot);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Error handling GUI click: " + e.getMessage());
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onInventoryDrag(InventoryDragEvent event) {
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof GUIManager.GUIHolder) {
            event.setCancelled(true);
        }
    }

    private void handleMainMenuClick(Player player, int slot) {
        ConfigManager config = this.plugin.getConfigManager();
        if (slot == config.getMainGUICloseSlot()) {
            player.closeInventory();
            return;
        }
        if (slot == config.getMainGUIInfoSlot()) {
            return;
        }
        int[] jobSlots = config.getMainGUIJobSlots();
        for (int i = 0; i < jobSlots.length; ++i) {
            if (slot != jobSlots[i]) continue;
            if (i < this.plugin.getJobManager().getJobsList().size()) {
                Job job = this.plugin.getJobManager().getJobsList().get(i);
                this.plugin.getGUIManager().openJobGUI(player, job.getId(), 0);
            }
            return;
        }
    }

    private void handleJobMenuClick(Player player, int slot) {
        ConfigManager config = this.plugin.getConfigManager();
        String jobId = this.plugin.getGUIManager().getCurrentJob(player.getUniqueId());
        int currentPage = this.plugin.getGUIManager().getCurrentPage(player.getUniqueId());
        if (jobId == null) {
            player.closeInventory();
            return;
        }
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            player.closeInventory();
            return;
        }
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (slot == config.getJobGUIBackSlot()) {
            this.plugin.getGUIManager().openMainJobsGUI(player);
            return;
        }
        if (slot == config.getJobGUIPreviousPageSlot()) {
            if (currentPage > 0) {
                this.plugin.getGUIManager().openJobGUI(player, jobId, currentPage - 1);
            }
            return;
        }
        if (slot == config.getJobGUIJoinLeaveSlot()) {
            if (data.hasJob(jobId)) {
                this.plugin.getPlayerDataManager().leaveJob(player, jobId);
                this.plugin.getMessageManager().sendJobLeft(player, job.getName());
                this.plugin.getGUIManager().openJobGUI(player, jobId, currentPage);
            } else if (!this.plugin.getPlayerDataManager().canJoinJob(player)) {
                int max = this.plugin.getPlayerDataManager().getMaxJobs(player);
                this.plugin.getMessageManager().sendMaxJobsReached(player, data.getJobCount(), max);
            } else {
                this.plugin.getPlayerDataManager().joinJob(player, jobId);
                this.plugin.getMessageManager().sendJobJoined(player, job.getName());
                this.plugin.getGUIManager().openJobGUI(player, jobId, currentPage);
            }
            return;
        }
        if (slot == config.getJobGUINextPageSlot()) {
            int totalPages = this.plugin.getGUIManager().getTotalPages(job);
            if (currentPage < totalPages - 1) {
                this.plugin.getGUIManager().openJobGUI(player, jobId, currentPage + 1);
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        InventoryHolder holder = event.getInventory().getHolder();
        if (holder instanceof GUIManager.GUIHolder) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (!(player.getOpenInventory().getTopInventory().getHolder() instanceof GUIManager.GUIHolder)) {
                    this.plugin.getGUIManager().clearPlayer(player.getUniqueId());
                }
            }, 1L);
        }
    }
}

