/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.listeners;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.ItemStack;

public class PlayerFishListener
implements Listener {
    private final SimpleJobs plugin;

    public PlayerFishListener(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerFish(PlayerFishEvent event) {
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            return;
        }
        if (!(event.getCaught() instanceof Item)) {
            return;
        }
        Player player = event.getPlayer();
        Item caughtItem = (Item)event.getCaught();
        ItemStack itemStack = caughtItem.getItemStack();
        Material material = itemStack.getType();
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        for (String jobId : data.getJobs()) {
            Job job = this.plugin.getJobManager().getJob(jobId);
            if (job == null || !job.hasFishingPayment(material)) continue;
            double basePayment = job.getFishingPayment(material);
            double multiplier = this.plugin.getPlayerDataManager().getMultiplier(player);
            double finalPayment = basePayment * multiplier;
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)player, finalPayment);
            String itemName = this.formatMaterialName(material.name());
            this.plugin.getMessageManager().sendPaymentReceived(player, job.getName(), itemName, finalPayment);
        }
    }

    private String formatMaterialName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder formatted = new StringBuilder();
        for (String word : words) {
            formatted.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return formatted.toString().trim();
    }
}

