/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.managers;

import com.pallux.simplejobs.SimpleJobs;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;

public class AntiAbuseManager {
    private final SimpleJobs plugin;
    private final Map<String, Long> placedBlocks;

    public AntiAbuseManager(SimpleJobs plugin) {
        this.plugin = plugin;
        this.placedBlocks = new HashMap<String, Long>();
    }

    public void markBlockPlaced(Block block) {
        if (!this.plugin.getConfigManager().isAntiAbuseEnabled()) {
            return;
        }
        String key = this.getBlockKey(block);
        this.placedBlocks.put(key, System.currentTimeMillis());
    }

    public boolean isRecentlyPlaced(Block block) {
        if (!this.plugin.getConfigManager().isAntiAbuseEnabled()) {
            return false;
        }
        String key = this.getBlockKey(block);
        if (!this.placedBlocks.containsKey(key)) {
            return false;
        }
        long placedTime = this.placedBlocks.get(key);
        long cooldown = (long)this.plugin.getConfigManager().getAntiAbuseCooldown() * 1000L;
        long currentTime = System.currentTimeMillis();
        if (currentTime - placedTime < cooldown) {
            return true;
        }
        this.placedBlocks.remove(key);
        return false;
    }

    public void removeBlock(Block block) {
        String key = this.getBlockKey(block);
        this.placedBlocks.remove(key);
    }

    public void clearAll() {
        this.placedBlocks.clear();
    }

    public void cleanupExpired() {
        long cooldown = (long)this.plugin.getConfigManager().getAntiAbuseCooldown() * 1000L;
        long currentTime = System.currentTimeMillis();
        this.placedBlocks.entrySet().removeIf(entry -> currentTime - (Long)entry.getValue() >= cooldown);
    }

    private String getBlockKey(Block block) {
        Location loc = block.getLocation();
        return loc.getWorld().getName() + ":" + loc.getBlockX() + ":" + loc.getBlockY() + ":" + loc.getBlockZ();
    }

    public void startCleanupTask() {
        if (!this.plugin.getConfigManager().isAntiAbuseEnabled()) {
            return;
        }
        this.plugin.getServer().getScheduler().runTaskTimer((Plugin)this.plugin, this::cleanupExpired, 6000L, 6000L);
    }
}

