/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.managers;

import com.pallux.simplejobs.SimpleJobs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final SimpleJobs plugin;
    private FileConfiguration config;

    public ConfigManager(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    public void loadConfig() {
        File configFile;
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        if (!(configFile = new File(this.plugin.getDataFolder(), "config.yml")).exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.config = YamlConfiguration.loadConfiguration((File)configFile);
        InputStream defConfigStream = this.plugin.getResource("config.yml");
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream));
            this.config.setDefaults((Configuration)defConfig);
        }
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public String getFillItemMaterial() {
        return this.config.getString("gui.fill-item", "BLACK_STAINED_GLASS_PANE");
    }

    public String getFillItemName() {
        return this.config.getString("gui.fill-item-name", " ");
    }

    public String getMainGUITitle() {
        return this.config.getString("gui.main-gui.title", "SimpleJobs - Jobs Menu");
    }

    public int getMainGUISize() {
        return this.config.getInt("gui.main-gui.size", 54);
    }

    public String getJobGUITitle(String jobName) {
        return this.config.getString("gui.job-gui.title", "{job} - Job Info").replace("{job}", jobName);
    }

    public int getJobGUISize() {
        return this.config.getInt("gui.job-gui.size", 54);
    }

    public boolean isAntiAbuseEnabled() {
        return this.config.getBoolean("anti-abuse.enabled", true);
    }

    public int getAntiAbuseCooldown() {
        return this.config.getInt("anti-abuse.cooldown-seconds", 30);
    }

    public int getMainGUIInfoSlot() {
        return this.config.getInt("gui.main-gui.info-item.slot", 4);
    }

    public int getMainGUICloseSlot() {
        return this.config.getInt("gui.main-gui.close-item.slot", 49);
    }

    public int[] getMainGUIJobSlots() {
        return this.config.getIntegerList("gui.main-gui.job-slots").stream().mapToInt(Integer::intValue).toArray();
    }

    public int getJobGUIIconSlot() {
        return this.config.getInt("gui.job-gui.job-icon-slot", 4);
    }

    public int getJobGUIJoinLeaveSlot() {
        return this.config.getInt("gui.job-gui.join-leave-button.slot", 49);
    }

    public int getJobGUIBackSlot() {
        return this.config.getInt("gui.job-gui.back-button.slot", 45);
    }

    public int getJobGUIPreviousPageSlot() {
        return this.config.getInt("gui.job-gui.previous-page.slot", 47);
    }

    public int getJobGUINextPageSlot() {
        return this.config.getInt("gui.job-gui.next-page.slot", 51);
    }

    public int[] getJobGUIPaymentSlots() {
        return this.config.getIntegerList("gui.job-gui.payment-slots").stream().mapToInt(Integer::intValue).toArray();
    }

    public void saveConfig() {
        try {
            this.config.save(new File(this.plugin.getDataFolder(), "config.yml"));
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save config.yml!");
            e.printStackTrace();
        }
    }
}

