/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.managers;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import com.pallux.simplejobs.utils.ColorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class GUIManager {
    private final SimpleJobs plugin;
    private final Map<UUID, GUIType> activeGUIs;
    private final Map<UUID, String> currentJob;
    private final Map<UUID, Integer> currentPage;

    public GUIManager(SimpleJobs plugin) {
        this.plugin = plugin;
        this.activeGUIs = new HashMap<UUID, GUIType>();
        this.currentJob = new HashMap<UUID, String>();
        this.currentPage = new HashMap<UUID, Integer>();
    }

    public void openMainJobsGUI(Player player) {
        String title = ColorUtils.colorize(this.plugin.getConfigManager().getMainGUITitle());
        Inventory gui = Bukkit.createInventory((InventoryHolder)new GUIHolder(GUIType.MAIN_MENU), (int)54, (String)title);
        this.fillEmptySlots(gui);
        int infoSlot = this.plugin.getConfigManager().getMainGUIInfoSlot();
        gui.setItem(infoSlot, this.createInfoItem());
        int closeSlot = this.plugin.getConfigManager().getMainGUICloseSlot();
        gui.setItem(closeSlot, this.createCloseButton());
        List<Job> jobs = this.plugin.getJobManager().getJobsList();
        int[] jobSlots = this.plugin.getConfigManager().getMainGUIJobSlots();
        for (int i = 0; i < jobs.size() && i < jobSlots.length; ++i) {
            gui.setItem(jobSlots[i], this.createJobItem(jobs.get(i), player));
        }
        this.activeGUIs.put(player.getUniqueId(), GUIType.MAIN_MENU);
        this.currentJob.remove(player.getUniqueId());
        this.currentPage.remove(player.getUniqueId());
        player.openInventory(gui);
    }

    public void openJobGUI(Player player, String jobId, int page) {
        Job job = this.plugin.getJobManager().getJob(jobId);
        if (job == null) {
            return;
        }
        this.activeGUIs.put(player.getUniqueId(), GUIType.JOB_MENU);
        this.currentJob.put(player.getUniqueId(), jobId);
        this.currentPage.put(player.getUniqueId(), page);
        String title = ColorUtils.colorize(this.plugin.getConfigManager().getJobGUITitle(job.getName()));
        Inventory gui = Bukkit.createInventory((InventoryHolder)new GUIHolder(GUIType.JOB_MENU), (int)54, (String)title);
        this.fillEmptySlots(gui);
        int iconSlot = this.plugin.getConfigManager().getJobGUIIconSlot();
        gui.setItem(iconSlot, this.createJobIconItem(job));
        int backSlot = this.plugin.getConfigManager().getJobGUIBackSlot();
        gui.setItem(backSlot, this.createBackButton());
        int joinLeaveSlot = this.plugin.getConfigManager().getJobGUIJoinLeaveSlot();
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (data.hasJob(jobId)) {
            gui.setItem(joinLeaveSlot, this.createLeaveJobButton());
        } else {
            gui.setItem(joinLeaveSlot, this.createJoinJobButton());
        }
        List<ItemStack> paymentItems = this.createPaymentItems(job);
        int[] itemSlots = this.plugin.getConfigManager().getJobGUIPaymentSlots();
        int startIndex = page * itemSlots.length;
        int endIndex = Math.min(startIndex + itemSlots.length, paymentItems.size());
        for (int i = startIndex; i < endIndex; ++i) {
            int slotIndex = i - startIndex;
            if (slotIndex >= itemSlots.length) continue;
            gui.setItem(itemSlots[slotIndex], paymentItems.get(i));
        }
        int prevSlot = this.plugin.getConfigManager().getJobGUIPreviousPageSlot();
        int nextSlot = this.plugin.getConfigManager().getJobGUINextPageSlot();
        if (page > 0) {
            gui.setItem(prevSlot, this.createPreviousPageButton(page));
        }
        if (endIndex < paymentItems.size()) {
            gui.setItem(nextSlot, this.createNextPageButton(page));
        }
        player.openInventory(gui);
    }

    private ItemStack createInfoItem() {
        ItemStack item = new ItemStack(Material.ENDER_EYE);
        ItemMeta meta = item.getItemMeta();
        String name = this.plugin.getConfigManager().getConfig().getString("gui.main-gui.info-item.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.main-gui.info-item.lore");
        meta.setDisplayName(ColorUtils.colorize(name));
        meta.setLore(ColorUtils.colorize(lore));
        item.setItemMeta(meta);
        return item;
    }

    private ItemStack createCloseButton() {
        String name = this.plugin.getConfigManager().getConfig().getString("gui.main-gui.close-item.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.main-gui.close-item.lore");
        Material material = Material.valueOf((String)this.plugin.getConfigManager().getConfig().getString("gui.main-gui.close-item.material", "BARRIER"));
        return this.createButton(material, name, lore);
    }

    private ItemStack createBackButton() {
        String name = this.plugin.getConfigManager().getConfig().getString("gui.job-gui.back-button.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.job-gui.back-button.lore");
        Material material = Material.valueOf((String)this.plugin.getConfigManager().getConfig().getString("gui.job-gui.back-button.material", "ARROW"));
        return this.createButton(material, name, lore);
    }

    private ItemStack createJoinJobButton() {
        String name = this.plugin.getConfigManager().getConfig().getString("gui.job-gui.join-leave-button.join.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.job-gui.join-leave-button.join.lore");
        Material material = Material.valueOf((String)this.plugin.getConfigManager().getConfig().getString("gui.job-gui.join-leave-button.join.material", "LIME_DYE"));
        return this.createButton(material, name, lore);
    }

    private ItemStack createLeaveJobButton() {
        String name = this.plugin.getConfigManager().getConfig().getString("gui.job-gui.join-leave-button.leave.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.job-gui.join-leave-button.leave.lore");
        Material material = Material.valueOf((String)this.plugin.getConfigManager().getConfig().getString("gui.job-gui.join-leave-button.leave.material", "RED_DYE"));
        return this.createButton(material, name, lore);
    }

    private ItemStack createPreviousPageButton(int currentPage) {
        String name = this.plugin.getConfigManager().getConfig().getString("gui.job-gui.previous-page.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.job-gui.previous-page.lore");
        Material material = Material.valueOf((String)this.plugin.getConfigManager().getConfig().getString("gui.job-gui.previous-page.material", "ARROW"));
        ArrayList<String> processedLore = new ArrayList<String>();
        for (String line : lore) {
            processedLore.add(line.replace("{page}", String.valueOf(currentPage)));
        }
        return this.createButton(material, name, processedLore);
    }

    private ItemStack createNextPageButton(int currentPage) {
        String name = this.plugin.getConfigManager().getConfig().getString("gui.job-gui.next-page.name");
        List lore = this.plugin.getConfigManager().getConfig().getStringList("gui.job-gui.next-page.lore");
        Material material = Material.valueOf((String)this.plugin.getConfigManager().getConfig().getString("gui.job-gui.next-page.material", "ARROW"));
        ArrayList<String> processedLore = new ArrayList<String>();
        for (String line : lore) {
            processedLore.add(line.replace("{page}", String.valueOf(currentPage + 2)));
        }
        return this.createButton(material, name, processedLore);
    }

    private ItemStack createJobItem(Job job, Player player) {
        ItemStack item = new ItemStack(job.getIcon());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ColorUtils.colorize("&#FFD700" + job.getName()));
            ArrayList<String> lore = new ArrayList<String>(ColorUtils.colorize(job.getDescription()));
            PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
            if (data.hasJob(job.getId())) {
                lore.add("");
                lore.add(ColorUtils.colorize("&#00FF00\u2713 Currently Active"));
            }
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private ItemStack createJobIconItem(Job job) {
        ItemStack item = new ItemStack(job.getIcon());
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(ColorUtils.colorize("<gradient:#FFD700:#FFA500>" + job.getName() + "</gradient>"));
            meta.setLore(ColorUtils.colorize(job.getDescription()));
            item.setItemMeta(meta);
        }
        return item;
    }

    private List<ItemStack> createPaymentItems(Job job) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry<Material, Double> entry : job.getBlockPayments().entrySet()) {
            items.add(this.createPaymentItem(entry.getKey(), entry.getValue(), "Breaking"));
        }
        for (Map.Entry<Material, Double> entry : job.getPlantingPayments().entrySet()) {
            items.add(this.createPaymentItem(entry.getKey(), entry.getValue(), "Planting"));
        }
        for (Map.Entry<Material, Double> entry : job.getEntityPayments().entrySet()) {
            items.add(this.createEntityPaymentItem((EntityType)entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<Material, Double> entry : job.getFishingPayments().entrySet()) {
            items.add(this.createPaymentItem(entry.getKey(), entry.getValue(), "Catching"));
        }
        return items;
    }

    private ItemStack createPaymentItem(Material material, double amount, String action) {
        Material displayMaterial = material;
        if (!material.isItem()) {
            displayMaterial = this.getSafeMaterial(material);
        }
        ItemStack item = new ItemStack(displayMaterial);
        ItemMeta meta = item.getItemMeta();
        String name = this.formatName(material.name());
        meta.setDisplayName(ColorUtils.colorize("&#FFFF00" + name));
        List<String> lore = Arrays.asList("", "&#FFFFFFAction: &#FFD700" + action, "&#FFFFFFPayment: &#00FF00$" + String.format("%.2f", amount), "");
        meta.setLore(ColorUtils.colorize(lore));
        item.setItemMeta(meta);
        return item;
    }

    private Material getSafeMaterial(Material material) {
        return switch (material.name()) {
            case "MELON_STEM", "ATTACHED_MELON_STEM" -> Material.MELON_SLICE;
            case "PUMPKIN_STEM", "ATTACHED_PUMPKIN_STEM" -> Material.PUMPKIN;
            case "CARROTS" -> Material.CARROT;
            case "POTATOES" -> Material.POTATO;
            case "BEETROOTS" -> Material.BEETROOT;
            case "WHEAT" -> Material.WHEAT_SEEDS;
            case "SWEET_BERRY_BUSH" -> Material.SWEET_BERRIES;
            case "CAVE_VINES", "CAVE_VINES_PLANT" -> Material.GLOW_BERRIES;
            case "KELP_PLANT" -> Material.KELP;
            case "COCOA" -> Material.COCOA_BEANS;
            default -> Material.PAPER;
        };
    }

    private ItemStack createEntityPaymentItem(EntityType entityType, double amount) {
        Material spawnEgg = this.getSpawnEggForEntity(entityType);
        ItemStack item = new ItemStack(spawnEgg);
        ItemMeta meta = item.getItemMeta();
        String name = this.formatName(entityType.name());
        meta.setDisplayName(ColorUtils.colorize("&#FFFF00" + name));
        List<String> lore = Arrays.asList("", "&#FFFFFFAction: &#FFD700Killing", "&#FFFFFFPayment: &#00FF00$" + String.format("%.2f", amount), "");
        meta.setLore(ColorUtils.colorize(lore));
        item.setItemMeta(meta);
        return item;
    }

    private Material getSpawnEggForEntity(EntityType entityType) {
        String spawnEggName = entityType.name() + "_SPAWN_EGG";
        try {
            Material spawnEgg = Material.valueOf((String)spawnEggName);
            if (spawnEgg.isItem()) {
                return spawnEgg;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return Material.PIG_SPAWN_EGG;
    }

    private ItemStack createButton(Material material, String name, List<String> lore) {
        ItemStack item = new ItemStack(material);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(ColorUtils.colorize(name));
        meta.setLore(ColorUtils.colorize(lore));
        item.setItemMeta(meta);
        return item;
    }

    private void fillEmptySlots(Inventory gui) {
        Material fillMaterial;
        try {
            fillMaterial = Material.valueOf((String)this.plugin.getConfigManager().getFillItemMaterial());
        }
        catch (IllegalArgumentException e) {
            fillMaterial = Material.BLACK_STAINED_GLASS_PANE;
        }
        ItemStack filler = new ItemStack(fillMaterial);
        ItemMeta meta = filler.getItemMeta();
        meta.setDisplayName(" ");
        filler.setItemMeta(meta);
        for (int i = 0; i < gui.getSize(); ++i) {
            gui.setItem(i, filler);
        }
    }

    private String formatName(String name) {
        String[] words = name.toLowerCase().split("_");
        StringBuilder result = new StringBuilder();
        for (String word : words) {
            if (word.length() <= 0) continue;
            result.append(Character.toUpperCase(word.charAt(0))).append(word.substring(1)).append(" ");
        }
        return result.toString().trim();
    }

    public int getTotalPages(Job job) {
        List<ItemStack> paymentItems = this.createPaymentItems(job);
        int[] itemSlots = this.plugin.getConfigManager().getJobGUIPaymentSlots();
        return (int)Math.ceil((double)paymentItems.size() / (double)itemSlots.length);
    }

    public GUIType getActiveGUI(UUID uuid) {
        return this.activeGUIs.get(uuid);
    }

    public String getCurrentJob(UUID uuid) {
        return this.currentJob.get(uuid);
    }

    public int getCurrentPage(UUID uuid) {
        return this.currentPage.getOrDefault(uuid, 0);
    }

    public void clearPlayer(UUID uuid) {
        this.activeGUIs.remove(uuid);
        this.currentJob.remove(uuid);
        this.currentPage.remove(uuid);
    }

    public static class GUIHolder
    implements InventoryHolder {
        private final GUIType type;

        public GUIHolder(GUIType type) {
            this.type = type;
        }

        public GUIType getType() {
            return this.type;
        }

        public Inventory getInventory() {
            return null;
        }
    }

    public static enum GUIType {
        MAIN_MENU,
        JOB_MENU;

    }
}

