/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.managers;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.jobs.Job;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;

public class JobManager {
    private final SimpleJobs plugin;
    private final Map<String, Job> jobs;

    public JobManager(SimpleJobs plugin) {
        this.plugin = plugin;
        this.jobs = new HashMap<String, Job>();
    }

    public void loadJobs() {
        File[] jobFiles;
        this.jobs.clear();
        File jobsFolder = new File(this.plugin.getDataFolder(), "jobs");
        if (!jobsFolder.exists()) {
            jobsFolder.mkdirs();
            this.plugin.saveResource("jobs/woodcutter.yml", false);
            this.plugin.saveResource("jobs/miner.yml", false);
            this.plugin.saveResource("jobs/farmer.yml", false);
            this.plugin.saveResource("jobs/fisher.yml", false);
            this.plugin.saveResource("jobs/hunter.yml", false);
        }
        if ((jobFiles = jobsFolder.listFiles((dir, name) -> name.endsWith(".yml"))) == null) {
            this.plugin.getLogger().warning("No job files found in jobs folder!");
            return;
        }
        for (File jobFile : jobFiles) {
            this.loadJob(jobFile);
        }
        this.plugin.getLogger().info("Loaded " + this.jobs.size() + " job(s)!");
    }

    private void loadJob(File file) {
        ConfigurationSection plantingSection;
        Material icon;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)file);
        String jobId = file.getName().replace(".yml", "");
        String jobName = config.getString("job.name", jobId);
        String shortName = config.getString("job.short-name", jobName.substring(0, 2).toUpperCase());
        try {
            icon = Material.valueOf((String)config.getString("job.icon", "STONE"));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Invalid icon material for job " + jobId + ", using STONE");
            icon = Material.STONE;
        }
        List description = config.getStringList("job.description");
        Job job = new Job(jobId, jobName, shortName, icon, description);
        ConfigurationSection paymentsSection = config.getConfigurationSection("payments");
        if (paymentsSection != null) {
            for (String key : paymentsSection.getKeys(false)) {
                try {
                    Material material;
                    double amount = paymentsSection.getDouble(key);
                    if (jobId.equalsIgnoreCase("fisher")) {
                        try {
                            material = Material.valueOf((String)key);
                            job.addFishingPayment(material, amount);
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Invalid material '" + key + "' in fisher job");
                        }
                        continue;
                    }
                    if (jobId.equalsIgnoreCase("hunter")) {
                        try {
                            EntityType entityType = EntityType.valueOf((String)key);
                            job.addEntityPayment(entityType, amount);
                        }
                        catch (IllegalArgumentException e) {
                            this.plugin.getLogger().warning("Invalid entity '" + key + "' in hunter job");
                        }
                        continue;
                    }
                    try {
                        material = Material.valueOf((String)key);
                        job.addBlockPayment(material, amount);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid material '" + key + "' in job " + jobId);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().warning("Error loading payment for '" + key + "' in job " + jobId + ": " + e.getMessage());
                }
            }
        }
        if ((plantingSection = config.getConfigurationSection("planting-payments")) != null) {
            for (String key : plantingSection.getKeys(false)) {
                try {
                    Material material = Material.valueOf((String)key);
                    double amount = plantingSection.getDouble(key);
                    job.addPlantingPayment(material, amount);
                }
                catch (IllegalArgumentException e) {
                    this.plugin.getLogger().warning("Invalid material '" + key + "' in planting-payments for job " + jobId);
                }
            }
        }
        this.jobs.put(jobId, job);
        this.plugin.getLogger().info("Loaded job: " + jobName + " (" + jobId + ")");
    }

    public Job getJob(String id) {
        return this.jobs.get(id.toLowerCase());
    }

    public Collection<Job> getAllJobs() {
        return this.jobs.values();
    }

    public List<Job> getJobsList() {
        return new ArrayList<Job>(this.jobs.values());
    }

    public boolean jobExists(String id) {
        return this.jobs.containsKey(id.toLowerCase());
    }

    public Map<String, Job> getJobs() {
        return this.jobs;
    }
}

