/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.managers;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.utils.ColorUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class MessageManager {
    private final SimpleJobs plugin;
    private FileConfiguration messages;

    public MessageManager(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    public void loadMessages() {
        File messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.plugin.saveResource("messages.yml", false);
        }
        this.messages = YamlConfiguration.loadConfiguration((File)messagesFile);
        InputStream defMessagesStream = this.plugin.getResource("messages.yml");
        if (defMessagesStream != null) {
            YamlConfiguration defMessages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defMessagesStream));
            this.messages.setDefaults((Configuration)defMessages);
        }
    }

    public String getMessage(String path) {
        String message = this.messages.getString(path, "&cMessage not found: " + path);
        String prefix = this.messages.getString("prefix", "[SimpleJobs] ");
        message = message.replace("{prefix}", prefix);
        return ColorUtils.colorize(message);
    }

    public String getMessage(String path, Map<String, String> placeholders) {
        String message = this.messages.getString(path, "&cMessage not found: " + path);
        String prefix = this.messages.getString("prefix", "[SimpleJobs] ");
        message = message.replace("{prefix}", prefix);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return ColorUtils.colorize(message);
    }

    public void sendMessage(Player player, String path) {
        player.sendMessage(this.getMessage(path));
    }

    public void sendMessage(Player player, String path, Map<String, String> placeholders) {
        player.sendMessage(this.getMessage(path, placeholders));
    }

    public void sendNoPermission(Player player) {
        this.sendMessage(player, "no-permission");
    }

    public void sendReloadSuccess(Player player) {
        this.sendMessage(player, "reload-success");
    }

    public void sendJobJoined(Player player, String jobName) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("job", jobName);
        this.sendMessage(player, "job-joined", placeholders);
    }

    public void sendJobLeft(Player player, String jobName) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("job", jobName);
        this.sendMessage(player, "job-left", placeholders);
    }

    public void sendAlreadyInJob(Player player, String jobName) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("job", jobName);
        this.sendMessage(player, "already-in-job", placeholders);
    }

    public void sendNotInJob(Player player, String jobName) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("job", jobName);
        this.sendMessage(player, "not-in-job", placeholders);
    }

    public void sendMaxJobsReached(Player player, int current, int max) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("current_jobs", String.valueOf(current));
        placeholders.put("max_jobs", String.valueOf(max));
        this.sendMessage(player, "max-jobs-reached", placeholders);
    }

    public void sendInvalidJob(Player player, String jobName) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("job", jobName);
        this.sendMessage(player, "invalid-job", placeholders);
    }

    public void sendPaymentReceived(Player player, String jobName, String item, double amount) {
        String message = ColorUtils.colorize("&#00FF00+$" + String.format("%.2f", amount));
        player.sendActionBar(message);
    }
}

