/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.managers;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerDataManager {
    private final SimpleJobs plugin;
    private final Map<UUID, PlayerData> playerDataMap;
    private File dataFile;
    private FileConfiguration dataConfig;

    public PlayerDataManager(SimpleJobs plugin) {
        this.plugin = plugin;
        this.playerDataMap = new HashMap<UUID, PlayerData>();
    }

    public void loadPlayerData() {
        this.dataFile = new File(this.plugin.getDataFolder(), "playerdata.yml");
        if (!this.dataFile.exists()) {
            try {
                this.dataFile.createNewFile();
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create playerdata.yml!");
                e.printStackTrace();
            }
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.dataFile);
        for (String uuidString : this.dataConfig.getKeys(false)) {
            try {
                UUID uuid = UUID.fromString(uuidString);
                PlayerData playerData = new PlayerData(uuid);
                List jobs = this.dataConfig.getStringList(uuidString + ".jobs");
                for (String job : jobs) {
                    playerData.addJob(job);
                }
                this.playerDataMap.put(uuid, playerData);
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid UUID in playerdata.yml: " + uuidString);
            }
        }
        this.plugin.getLogger().info("Loaded data for " + this.playerDataMap.size() + " player(s)!");
    }

    public void savePlayerData() {
        for (PlayerData playerData : this.playerDataMap.values()) {
            String uuid = playerData.getUuid().toString();
            this.dataConfig.set(uuid + ".jobs", playerData.getJobs());
        }
        try {
            this.dataConfig.save(this.dataFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().severe("Could not save playerdata.yml!");
            e.printStackTrace();
        }
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataMap.computeIfAbsent(uuid, PlayerData::new);
    }

    public PlayerData getPlayerData(Player player) {
        return this.getPlayerData(player.getUniqueId());
    }

    public int getMaxJobs(Player player) {
        for (int i = 5; i >= 1; --i) {
            if (!player.hasPermission("simplejobs.jobs." + i)) continue;
            return i;
        }
        return 1;
    }

    public double getMultiplier(Player player) {
        int[] multipliers;
        double highestMultiplier = 1.0;
        for (int mult : multipliers = new int[]{100, 75, 50, 25, 10}) {
            if (!player.hasPermission("simplejobs.premium." + mult)) continue;
            highestMultiplier = 1.0 + (double)mult / 100.0;
            break;
        }
        return highestMultiplier;
    }

    public boolean canJoinJob(Player player) {
        PlayerData data = this.getPlayerData(player);
        return data.getJobCount() < this.getMaxJobs(player);
    }

    public void joinJob(Player player, String jobId) {
        PlayerData data = this.getPlayerData(player);
        data.addJob(jobId);
        this.savePlayerData();
    }

    public void leaveJob(Player player, String jobId) {
        PlayerData data = this.getPlayerData(player);
        data.removeJob(jobId);
        this.savePlayerData();
    }
}

