/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.placeholders;

import com.pallux.simplejobs.SimpleJobs;
import com.pallux.simplejobs.data.PlayerData;
import com.pallux.simplejobs.jobs.Job;
import java.util.ArrayList;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class SimpleJobsPlaceholder
extends PlaceholderExpansion {
    private final SimpleJobs plugin;

    public SimpleJobsPlaceholder(SimpleJobs plugin) {
        this.plugin = plugin;
    }

    @NotNull
    public String getAuthor() {
        return "Pallux";
    }

    @NotNull
    public String getIdentifier() {
        return "simplejobs";
    }

    @NotNull
    public String getVersion() {
        return "1.0.0";
    }

    public boolean persist() {
        return true;
    }

    public String onPlaceholderRequest(Player player, @NotNull String params) {
        if (player == null) {
            return "";
        }
        PlayerData data = this.plugin.getPlayerDataManager().getPlayerData(player);
        if (params.equalsIgnoreCase("job")) {
            if (data.getJobCount() == 0) {
                return "None";
            }
            ArrayList<String> shortNames = new ArrayList<String>();
            for (String jobId : data.getJobs()) {
                Job job = this.plugin.getJobManager().getJob(jobId);
                if (job == null) continue;
                shortNames.add(job.getShortName());
            }
            return String.join((CharSequence)"/", shortNames);
        }
        if (params.equalsIgnoreCase("multiplier")) {
            double multiplier = this.plugin.getPlayerDataManager().getMultiplier(player);
            return "x" + String.format("%.1f", multiplier);
        }
        if (params.equalsIgnoreCase("jobs_count")) {
            return String.valueOf(data.getJobCount());
        }
        if (params.equalsIgnoreCase("max_jobs")) {
            return String.valueOf(this.plugin.getPlayerDataManager().getMaxJobs(player));
        }
        if (params.equalsIgnoreCase("job_list")) {
            if (data.getJobCount() == 0) {
                return "None";
            }
            ArrayList<String> jobNames = new ArrayList<String>();
            for (String jobId : data.getJobs()) {
                Job job = this.plugin.getJobManager().getJob(jobId);
                if (job == null) continue;
                jobNames.add(job.getName());
            }
            return String.join((CharSequence)", ", jobNames);
        }
        return null;
    }
}

