/*
 * Decompiled with CFR 0.152.
 */
package com.pallux.simplejobs.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;

public class ColorUtils {
    private static final Pattern HEX_PATTERN = Pattern.compile("&#([A-Fa-f0-9]{6})");
    private static final Pattern GRADIENT_PATTERN = Pattern.compile("<gradient:(#[A-Fa-f0-9]{6}):(#[A-Fa-f0-9]{6})>([^<]+)</gradient>");

    public static String colorize(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        message = ColorUtils.processGradients(message);
        message = ColorUtils.processHexColors(message);
        message = ChatColor.translateAlternateColorCodes((char)'&', (String)message);
        return message;
    }

    public static List<String> colorize(List<String> messages) {
        ArrayList<String> colorized = new ArrayList<String>();
        for (String message : messages) {
            colorized.add(ColorUtils.colorize(message));
        }
        return colorized;
    }

    private static String processHexColors(String message) {
        Matcher matcher = HEX_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String hexCode = matcher.group(1);
            matcher.appendReplacement(buffer, ChatColor.of((String)("#" + hexCode)).toString());
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String processGradients(String message) {
        Matcher matcher = GRADIENT_PATTERN.matcher(message);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String startHex = matcher.group(1);
            String endHex = matcher.group(2);
            String text = matcher.group(3);
            String gradient = ColorUtils.applyGradient(text, startHex, endHex);
            matcher.appendReplacement(buffer, Matcher.quoteReplacement(gradient));
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    private static String applyGradient(String text, String startHex, String endHex) {
        Color startColor = Color.decode(startHex);
        Color endColor = Color.decode(endHex);
        StringBuilder result = new StringBuilder();
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (c == ' ') {
                result.append(c);
                continue;
            }
            float ratio = (float)i / (float)(length - 1);
            int red = (int)((float)startColor.getRed() + ratio * (float)(endColor.getRed() - startColor.getRed()));
            int green = (int)((float)startColor.getGreen() + ratio * (float)(endColor.getGreen() - startColor.getGreen()));
            int blue = (int)((float)startColor.getBlue() + ratio * (float)(endColor.getBlue() - startColor.getBlue()));
            Color color = new Color(red, green, blue);
            result.append(ChatColor.of((Color)color)).append(c);
        }
        return result.toString();
    }

    public static String stripColor(String message) {
        if (message == null || message.isEmpty()) {
            return message;
        }
        return ChatColor.stripColor((String)ColorUtils.colorize(message));
    }
}

