/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.sponge10.handler;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.common.queue.SignedResult;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.shared.types.ResultType;
import java.util.UUID;
import org.spongepowered.api.network.EngineConnection;
import org.spongepowered.api.network.channel.ChannelBuf;
import org.spongepowered.api.network.channel.raw.play.RawPlayDataHandler;

public final class ProxyDataHandler
implements RawPlayDataHandler<EngineConnection> {
    @Inject
    @Named(value="chat")
    private SignedQueue chatQueue;
    @Inject
    @Named(value="command")
    private SignedQueue commandQueue;

    public void handlePayload(ChannelBuf data, EngineConnection connection) {
        UUID playerId = UUID.fromString(data.readUTF());
        String source = data.readUTF();
        String result = data.readUTF();
        SignedQueue queue = switch (QueueType.getOrThrow(source)) {
            default -> throw new MatchException(null, null);
            case QueueType.COMMAND -> this.commandQueue;
            case QueueType.CHAT -> this.chatQueue;
        };
        SignedResult resulted = switch (ResultType.getOrThrow(result)) {
            default -> throw new MatchException(null, null);
            case ResultType.CANCEL -> SignedResult.cancel();
            case ResultType.MODIFY -> SignedResult.modify(data.readUTF());
            case ResultType.ALLOWED -> SignedResult.allowed();
        };
        queue.dataFrom(playerId).complete(resulted);
    }
}

