/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.sponge10.listener;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.sponge.common.listener.SignedListener;
import java.util.UUID;
import org.spongepowered.api.event.EventListener;
import org.spongepowered.api.event.EventListenerRegistration;
import org.spongepowered.api.event.EventManager;
import org.spongepowered.api.event.Order;
import org.spongepowered.api.event.network.ServerSideConnectionEvent;
import org.spongepowered.plugin.PluginContainer;

public final class PlayerQuitListener
implements SignedListener<ServerSideConnectionEvent.Disconnect> {
    @Inject
    @Named(value="chat")
    private SignedQueue chatQueue;
    @Inject
    @Named(value="command")
    private SignedQueue commandQueue;
    @Inject
    private EventManager eventManager;
    @Inject
    private PluginContainer pluginContainer;

    @Override
    public void register() {
        this.eventManager.registerListener(EventListenerRegistration.builder(ServerSideConnectionEvent.Disconnect.class).listener((EventListener)this).plugin(this.pluginContainer).order(Order.DEFAULT).beforeModifications(false).build());
    }

    public void handle(ServerSideConnectionEvent.Disconnect event) {
        UUID playerUUID = event.player().uniqueId();
        this.chatQueue.removeData(playerUUID);
        this.commandQueue.removeData(playerUUID);
    }
}

