/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.velocity;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.velocitypowered.api.event.Subscribe;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.plugin.Dependency;
import com.velocitypowered.api.plugin.Plugin;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import io.github._4drian3d.signedvelocity.libs.bstats.velocity.Metrics;
import io.github._4drian3d.signedvelocity.velocity.cache.ModificationCache;
import io.github._4drian3d.signedvelocity.velocity.listener.Listener;
import io.github._4drian3d.signedvelocity.velocity.packet.PacketAdapter;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import org.slf4j.Logger;

@Plugin(id="signedvelocity", authors={"4drian3d"}, version="1.4.1", description="Allows you to cancel or modify messages or commands from Velocity without synchronization problems", dependencies={@Dependency(id="vpacketevents", optional=true), @Dependency(id="packetevents", optional=true)})
public final class SignedVelocity {
    private static final boolean DEBUG = Boolean.getBoolean("io.github._4drian3d.signedvelocity.debug");
    public static final ChannelIdentifier SIGNEDVELOCITY_CHANNEL = MinecraftChannelIdentifier.create((String)"signedvelocity", (String)"main");
    private final Cache<String, ModificationCache> modificationCache = Caffeine.newBuilder().expireAfterWrite(Duration.of(1L, ChronoUnit.SECONDS)).build();
    @Inject
    private Injector injector;
    @Inject
    private Logger logger;
    @Inject
    private Metrics.Factory factory;
    @Inject
    private PluginManager pluginManager;

    @Subscribe
    public void onProxyInitialization(ProxyInitializeEvent event) {
        this.factory.make(this, 18937);
        this.logger.info("Starting SignedVelocity");
        Listener.register(this.injector);
        PacketAdapter.register(this.injector, this.pluginManager);
    }

    public Cache<String, ModificationCache> modificationCache() {
        return this.modificationCache;
    }

    public void logDebug(String string) {
        if (DEBUG) {
            this.logger.info("SIGNEDVELOCITY DEBUG | {}", (Object)string);
        }
    }
}

