/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.velocity.listener;

import com.google.inject.Injector;
import com.velocitypowered.api.event.AwaitingEventExecutor;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.shared.types.ResultType;
import io.github._4drian3d.signedvelocity.velocity.SignedVelocity;
import io.github._4drian3d.signedvelocity.velocity.listener.PlayerChatListener;
import io.github._4drian3d.signedvelocity.velocity.listener.PlayerCommandListener;
import io.github._4drian3d.signedvelocity.velocity.listener.PluginMessageListener;
import io.github._4drian3d.signedvelocity.velocity.listener.PostPlayerCommandListener;
import org.jspecify.annotations.NullMarked;

@NullMarked
public sealed interface Listener<E>
extends AwaitingEventExecutor<E>
permits PlayerChatListener, PlayerCommandListener, PluginMessageListener, PostPlayerCommandListener {
    public void register();

    public static void register(Injector injector) {
        Listener[] listeners;
        for (Listener listener : listeners = new Listener[]{(Listener)injector.getInstance(PlayerChatListener.class), (Listener)injector.getInstance(PlayerCommandListener.class), (Listener)injector.getInstance(PostPlayerCommandListener.class), (Listener)injector.getInstance(PluginMessageListener.class)}) {
            listener.register();
        }
    }

    default public void sendAllowedData(Player player, ServerConnection connection, QueueType queueType) {
        connection.sendPluginMessage(SignedVelocity.SIGNEDVELOCITY_CHANNEL, output -> {
            output.writeUTF(player.getUniqueId().toString());
            output.writeUTF(queueType.value());
            output.writeUTF(ResultType.ALLOWED.value());
        });
    }

    default public void sendCancelData(Player player, ServerConnection connection, QueueType queueType) {
        connection.sendPluginMessage(SignedVelocity.SIGNEDVELOCITY_CHANNEL, output -> {
            output.writeUTF(player.getUniqueId().toString());
            output.writeUTF(queueType.value());
            output.writeUTF(ResultType.CANCEL.value());
        });
    }

    default public void sendModifiedData(Player player, ServerConnection connection, QueueType queueType, String modifiedString) {
        connection.sendPluginMessage(SignedVelocity.SIGNEDVELOCITY_CHANNEL, output -> {
            output.writeUTF(player.getUniqueId().toString());
            output.writeUTF(queueType.value());
            output.writeUTF(ResultType.MODIFY.value());
            output.writeUTF(modifiedString);
        });
    }
}

