/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.velocity.listener;

import com.google.inject.Inject;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.player.PlayerChatEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.velocity.SignedVelocity;
import io.github._4drian3d.signedvelocity.velocity.listener.Listener;
import java.util.Objects;

final class PlayerChatListener
implements Listener<PlayerChatEvent> {
    @Inject
    private EventManager eventManager;
    @Inject
    private SignedVelocity plugin;

    PlayerChatListener() {
    }

    public EventTask executeAsync(PlayerChatEvent event) {
        PlayerChatEvent.ChatResult result = event.getResult();
        return EventTask.withContinuation(continuation -> {
            Player player = event.getPlayer();
            if (!result.isAllowed() && player.getProtocolVersion().compareTo((Enum)ProtocolVersion.MINECRAFT_1_19_1) < 0) {
                continuation.resume();
                return;
            }
            ServerConnection server = (ServerConnection)player.getCurrentServer().orElseThrow();
            if (result == PlayerChatEvent.ChatResult.allowed()) {
                this.sendAllowedData(player, server, QueueType.CHAT);
                continuation.resume();
                return;
            }
            event.setResult(PlayerChatEvent.ChatResult.allowed());
            String finalMessage = result.getMessage().orElse(null);
            if (finalMessage == null) {
                this.sendCancelData(player, server, QueueType.CHAT);
                continuation.resume();
                return;
            }
            if (Objects.equals(finalMessage, event.getMessage())) {
                this.sendAllowedData(player, server, QueueType.CHAT);
                continuation.resume();
                return;
            }
            this.sendModifiedData(player, server, QueueType.CHAT, finalMessage);
            continuation.resume();
        });
    }

    @Override
    public void register() {
        this.eventManager.register((Object)this.plugin, PlayerChatEvent.class, (short)Short.MIN_VALUE, (EventHandler)this);
    }
}

