/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.velocity.listener;

import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandManager;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.velocity.SignedVelocity;
import io.github._4drian3d.signedvelocity.velocity.cache.ModificationCache;
import io.github._4drian3d.signedvelocity.velocity.listener.Listener;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

final class PlayerCommandListener
implements Listener<CommandExecuteEvent> {
    @Inject
    private EventManager eventManager;
    @Inject
    private CommandManager commandManager;
    @Inject
    private SignedVelocity plugin;

    PlayerCommandListener() {
    }

    @Override
    public void register() {
        this.eventManager.register((Object)this.plugin, CommandExecuteEvent.class, (short)-32760, (EventHandler)this);
    }

    public @Nullable EventTask executeAsync(CommandExecuteEvent event) {
        CommandExecuteEvent.InvocationInfo invocationInfo = event.getInvocationInfo();
        if (invocationInfo.source() == CommandExecuteEvent.Source.API) {
            return null;
        }
        CommandSource commandSource = event.getCommandSource();
        if (!(commandSource instanceof Player)) {
            return null;
        }
        Player player = (Player)commandSource;
        return EventTask.withContinuation(continuation -> {
            ServerConnection server = player.getCurrentServer().orElse(null);
            if (server == null) {
                this.plugin.logDebug("Command Execution | Null Server");
                continuation.resume();
                return;
            }
            CommandExecuteEvent.CommandResult result = event.getResult();
            String finalCommand = result.getCommand().orElse(null);
            if (result.isForwardToServer()) {
                this.plugin.logDebug("Command Execution | Forward to Server");
                if (finalCommand != null) {
                    this.plugin.logDebug("Command Execution | Signed Command Executed, modified and forwarded");
                    event.setResult(CommandExecuteEvent.CommandResult.forwardToServer());
                    this.sendModifiedData(player, server, QueueType.COMMAND, finalCommand);
                    continuation.resume();
                    return;
                }
                this.plugin.logDebug("Command Execution | Command Forwarded to server");
                this.sendAllowedData(player, server, QueueType.COMMAND);
                continuation.resume();
                return;
            }
            boolean isProxyCommand = this.isProxyCommand(event.getCommand());
            if (result == CommandExecuteEvent.CommandResult.allowed() || Objects.equals(finalCommand, event.getCommand())) {
                this.plugin.logDebug("Command Execution | Allowed Command");
                if (!isProxyCommand) {
                    this.plugin.logDebug("Command Execution | Allowed non proxied command");
                }
                continuation.resume();
                return;
            }
            if (!result.isAllowed() && player.getProtocolVersion().lessThan((Object)ProtocolVersion.MINECRAFT_1_19_1)) {
                this.plugin.logDebug("Command Execution | Old player version, denied command");
                event.setResult(CommandExecuteEvent.CommandResult.denied());
                continuation.resume();
                return;
            }
            if (finalCommand == null) {
                this.plugin.logDebug("Command Execution | Cancelled command execution");
                this.sendCancelData(player, server, QueueType.COMMAND);
                event.setResult(CommandExecuteEvent.CommandResult.forwardToServer());
                continuation.resume();
                return;
            }
            this.plugin.logDebug("Command Execution | Modification Section");
            if (!isProxyCommand) {
                this.plugin.logDebug("Command Execution | Non proxied command");
                this.sendModifiedData(player, server, QueueType.COMMAND, finalCommand);
                event.setResult(CommandExecuteEvent.CommandResult.forwardToServer());
                continuation.resume();
                return;
            }
            this.plugin.logDebug("Command Execution | Modified Command sent to Velocity Command Dispatcher");
            event.setResult(CommandExecuteEvent.CommandResult.command((String)finalCommand));
            this.plugin.modificationCache().put((Object)player.getUniqueId().toString(), (Object)new ModificationCache(event.getCommand(), finalCommand));
            continuation.resume();
        });
    }

    private boolean isProxyCommand(String command) {
        int firstIndexOfSpace = command.indexOf(32);
        return switch (firstIndexOfSpace) {
            case -1 -> this.commandManager.hasCommand(command);
            case 0 -> {
                String[] arguments;
                for (String argument : arguments = command.split(" ")) {
                    if (argument.isBlank()) continue;
                    yield this.commandManager.hasCommand(argument);
                }
                String firstArgument = command.substring(0, firstIndexOfSpace);
                yield this.commandManager.hasCommand(firstArgument);
            }
            default -> {
                String firstArgument = command.substring(0, firstIndexOfSpace);
                yield this.commandManager.hasCommand(firstArgument);
            }
        };
    }
}

