/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.velocity.listener;

import com.google.inject.Inject;
import com.velocitypowered.api.command.CommandResult;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.EventHandler;
import com.velocitypowered.api.event.EventManager;
import com.velocitypowered.api.event.EventTask;
import com.velocitypowered.api.event.command.PostCommandInvocationEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.velocity.SignedVelocity;
import io.github._4drian3d.signedvelocity.velocity.cache.ModificationCache;
import io.github._4drian3d.signedvelocity.velocity.listener.Listener;

public final class PostPlayerCommandListener
implements Listener<PostCommandInvocationEvent> {
    @Inject
    private SignedVelocity plugin;
    @Inject
    private EventManager eventManager;

    @Override
    public void register() {
        this.eventManager.register((Object)this.plugin, PostCommandInvocationEvent.class, (short)Short.MIN_VALUE, (EventHandler)this);
    }

    public EventTask executeAsync(PostCommandInvocationEvent event) {
        return EventTask.async(() -> {
            CommandSource patt0$temp;
            if (event.getResult() == CommandResult.FORWARDED && (patt0$temp = event.getCommandSource()) instanceof Player) {
                Player player = (Player)patt0$temp;
                this.plugin.logDebug("Post Command Execution | Forwarded Command: " + event.getCommand());
                String playerUUID = player.getUniqueId().toString();
                ModificationCache cache = (ModificationCache)this.plugin.modificationCache().getIfPresent((Object)playerUUID);
                this.plugin.modificationCache().invalidate((Object)playerUUID);
                player.getCurrentServer().ifPresent(connection -> {
                    this.plugin.logDebug("Post Command Execution | Server Available");
                    if (cache != null && cache.modifiedCommand().equals(event.getCommand())) {
                        this.plugin.logDebug("Post Command Execution | Modified Command");
                        this.sendModifiedData(player, (ServerConnection)connection, QueueType.COMMAND, event.getCommand());
                    } else {
                        this.plugin.logDebug("Post Command Execution | Non modified command");
                        this.sendAllowedData(player, (ServerConnection)connection, QueueType.COMMAND);
                    }
                });
            }
        });
    }
}

