/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.common.queue;

import io.github._4drian3d.signedvelocity.common.queue.SignedResult;
import io.github._4drian3d.signedvelocity.shared.PropertyHolder;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.Nullable;

public final class QueuedData {
    private static final int timeout = PropertyHolder.readInt("io.github._4drian3d.signedvelocity.timeout", 20);
    private final Queue<SignedResult> results = new ConcurrentLinkedQueue<SignedResult>();
    private final Queue<CompletableFuture<SignedResult>> unSyncronizedQueue = new ConcurrentLinkedQueue<CompletableFuture<SignedResult>>();

    public void complete(SignedResult result) {
        this.results.add(result);
        CompletableFuture<SignedResult> unSynchronized = this.unSyncronizedQueue.poll();
        if (unSynchronized != null) {
            unSynchronized.complete(result);
        }
    }

    public CompletableFuture<SignedResult> nextResult() {
        SignedResult result = this.results.poll();
        return this.futureFrom(result);
    }

    public CompletableFuture<SignedResult> nextResultWithoutAdvance() {
        SignedResult result = this.results.peek();
        return this.futureFrom(result);
    }

    private CompletableFuture<SignedResult> futureFrom(@Nullable SignedResult result) {
        if (result == null) {
            CompletableFuture<SignedResult> future = new CompletableFuture<SignedResult>();
            future.completeOnTimeout(SignedResult.allowed(), timeout, TimeUnit.MILLISECONDS);
            this.unSyncronizedQueue.add(future);
            return future;
        }
        return CompletableFuture.completedFuture(result);
    }
}

