/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.fabric;

import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.common.queue.SignedResult;
import io.github._4drian3d.signedvelocity.fabric.model.QueuedDataPacket;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.shared.types.ResultType;
import java.util.UUID;
import net.fabricmc.api.DedicatedServerModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2960;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SignedVelocity
implements DedicatedServerModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SignedVelocity");
    public static final class_2960 CHANNEL = class_2960.method_60655((String)"signedvelocity", (String)"main");
    public static final SignedQueue CHAT_QUEUE = new SignedQueue();
    public static final SignedQueue COMMAND_QUEUE = new SignedQueue();

    public void onInitializeServer() {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            UUID uuid = handler.method_32311().method_5667();
            CHAT_QUEUE.removeData(uuid);
            COMMAND_QUEUE.removeData(uuid);
        });
        PayloadTypeRegistry.playC2S().register(QueuedDataPacket.PACKET_ID, QueuedDataPacket.PACKET_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(QueuedDataPacket.PACKET_ID, (packet, context) -> {
            SignedQueue queue = switch (QueueType.getOrThrow(packet.source())) {
                default -> throw new MatchException(null, null);
                case QueueType.COMMAND -> COMMAND_QUEUE;
                case QueueType.CHAT -> CHAT_QUEUE;
            };
            SignedResult resulted = switch (ResultType.getOrThrow(packet.result())) {
                default -> throw new MatchException(null, null);
                case ResultType.CANCEL -> SignedResult.cancel();
                case ResultType.MODIFY -> SignedResult.modify(packet.modifiedMessage());
                case ResultType.ALLOWED -> SignedResult.allowed();
            };
            queue.dataFrom(packet.playerId()).complete(resulted);
        });
        LOGGER.info("Started SignedVelocity");
    }
}

