/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.fabric.model;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import io.github._4drian3d.signedvelocity.fabric.SignedVelocity;
import io.github._4drian3d.signedvelocity.shared.types.ResultType;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record QueuedDataPacket(UUID playerId, String source, String result, @Nullable String modifiedMessage) implements class_8710
{
    public static final class_8710.class_9154<QueuedDataPacket> PACKET_ID = new class_8710.class_9154(SignedVelocity.CHANNEL);
    public static final class_9139<ByteBuf, QueuedDataPacket> PACKET_CODEC = class_8710.method_56484(QueuedDataPacket::write, QueuedDataPacket::generate);

    public static QueuedDataPacket generate(ByteBuf buf) {
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])QueuedDataPacket.convertFromBuf(buf));
        UUID playerId = UUID.fromString(input.readUTF());
        String source = input.readUTF();
        String result = input.readUTF();
        String modifiedMessage = result.equals(ResultType.MODIFY.value()) ? input.readUTF() : null;
        return new QueuedDataPacket(playerId, source, result, modifiedMessage);
    }

    public static void write(QueuedDataPacket packet, ByteBuf buf) {
        class_2540 friendlyByteBuf = new class_2540(buf);
        friendlyByteBuf.method_10797(packet.playerId());
        friendlyByteBuf.method_10814(packet.source);
        friendlyByteBuf.method_10814(packet.result);
        if (packet.result.equals(ResultType.MODIFY.value())) {
            friendlyByteBuf.method_10814(packet.modifiedMessage);
        }
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return PACKET_ID;
    }

    private static byte[] convertFromBuf(ByteBuf buf) {
        byte[] bytes = new byte[buf.readableBytes()];
        buf.readBytes(bytes);
        return bytes;
    }
}

