/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.paper.listener;

import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.paper.SignedVelocity;
import io.github._4drian3d.signedvelocity.paper.listener.EventListener;
import io.papermc.paper.event.player.AsyncChatDecorateEvent;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;

public final class DecorateChatListener
implements EventListener<AsyncChatDecorateEvent> {
    private final SignedQueue chatQueue;

    public DecorateChatListener(SignedVelocity plugin) {
        this.chatQueue = plugin.getChatQueue();
    }

    @Override
    @NotNull
    public EventPriority priority() {
        return EventPriority.LOWEST;
    }

    @Override
    public boolean ignoreCancelled() {
        return true;
    }

    @Override
    public void handle(@NotNull AsyncChatDecorateEvent event) {
        Player player = event.player();
        if (player == null) {
            return;
        }
        ((CompletableFuture)this.chatQueue.dataFrom(player.getUniqueId()).nextResultWithoutAdvance().thenAccept(result -> {
            String modifiedChat = result.toModify();
            if (modifiedChat != null) {
                event.result((Component)Component.text((String)modifiedChat));
            }
        })).join();
    }

    @Override
    @NotNull
    public Class<AsyncChatDecorateEvent> eventClass() {
        return AsyncChatDecorateEvent.class;
    }
}

