/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.paper.listener;

import io.github._4drian3d.signedvelocity.common.queue.QueuedData;
import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.common.queue.SignedResult;
import io.github._4drian3d.signedvelocity.paper.SignedVelocity;
import io.github._4drian3d.signedvelocity.paper.listener.EventListener;
import io.github._4drian3d.signedvelocity.paper.listener.LocalExecutionDetector;
import io.github._4drian3d.signedvelocity.shared.logger.DebugLogger;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.jetbrains.annotations.NotNull;

public final class PlayerChatListener
implements EventListener<AsyncChatEvent>,
LocalExecutionDetector {
    private final SignedQueue chatQueue;
    private final DebugLogger debugLogger;

    public PlayerChatListener(SignedVelocity plugin) {
        this.chatQueue = plugin.getChatQueue();
        this.debugLogger = plugin.debugLogger();
    }

    @Override
    @NotNull
    public EventPriority priority() {
        return EventPriority.LOWEST;
    }

    @Override
    public boolean ignoreCancelled() {
        return false;
    }

    @Override
    public void handle(@NotNull AsyncChatEvent event) {
        this.debugLogger.debug(() -> "[CHAT] Init Message Handling | Received on: " + System.currentTimeMillis());
        if (CHECK_FOR_LOCAL_CHAT && (!event.isAsynchronous() || this.isLocal())) {
            this.debugLogger.debug(() -> "[CHAT] Local Message Executed");
            return;
        }
        Player player = event.getPlayer();
        this.debugLogger.debug(() -> "[CHAT] Queueing Next Result");
        QueuedData data = this.chatQueue.dataFrom(player.getUniqueId());
        CompletableFuture<SignedResult> nextResult = data.nextResult();
        this.debugLogger.debug(() -> "[CHAT] Future Done: " + nextResult.isDone());
        if (event.isCancelled()) {
            this.debugLogger.debug(() -> "[CHAT] Deprecated Event Cancelled");
            return;
        }
        this.debugLogger.debug(() -> "[CHAT] Waiting for next result");
        ((CompletableFuture)nextResult.thenAccept(result -> {
            this.debugLogger.debug(() -> "[CHAT] Next Result");
            if (result.cancelled()) {
                this.debugLogger.debugMultiple(() -> new String[]{"[CHAT] Cancelled Message.", "Original Message: " + PlainTextComponentSerializer.plainText().serialize(event.message())});
                event.setCancelled(true);
            } else {
                String modifiedChat = result.toModify();
                if (modifiedChat != null) {
                    this.debugLogger.debugMultiple(() -> new String[]{"[CHAT] Modified message", "Original: " + PlainTextComponentSerializer.plainText().serialize(event.message()), "Message: " + modifiedChat});
                    event.message((Component)Component.text((String)modifiedChat));
                }
            }
            this.debugLogger.debug(() -> "[CHAT] Result applied");
        })).join();
    }

    @Override
    @NotNull
    public Class<AsyncChatEvent> eventClass() {
        return AsyncChatEvent.class;
    }

    @Override
    public boolean isLocal() {
        return WALKER.walk(stream -> stream.limit(20L).map(StackWalker.StackFrame::getMethodName).noneMatch(method -> method.contains("handleChat")));
    }
}

