/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.paper.listener;

import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.paper.SignedVelocity;
import io.github._4drian3d.signedvelocity.paper.listener.EventListener;
import io.github._4drian3d.signedvelocity.paper.listener.LocalExecutionDetector;
import io.github._4drian3d.signedvelocity.shared.logger.DebugLogger;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import org.bukkit.entity.Player;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.jetbrains.annotations.NotNull;

public final class PlayerCommandListener
implements EventListener<PlayerCommandPreprocessEvent>,
LocalExecutionDetector {
    private final SignedQueue commandQueue;
    private final DebugLogger debugLogger;

    public PlayerCommandListener(SignedVelocity plugin) {
        this.commandQueue = plugin.getCommandQueue();
        this.debugLogger = plugin.debugLogger();
    }

    @Override
    @NotNull
    public EventPriority priority() {
        return EventPriority.LOWEST;
    }

    @Override
    public boolean ignoreCancelled() {
        return false;
    }

    @Override
    public void handle(@NotNull PlayerCommandPreprocessEvent event) {
        if (CHECK_FOR_LOCAL_CHAT && this.isLocal()) {
            this.debugLogger.debug(() -> "[COMMAND] Local Command Executed");
            return;
        }
        Player player = event.getPlayer();
        ((CompletableFuture)this.commandQueue.dataFrom(player.getUniqueId()).nextResult().thenAccept(result -> {
            if (result.cancelled()) {
                this.debugLogger.debug(() -> "[COMMAND] Canceled Command. Command: " + event.getMessage());
                event.setCancelled(true);
            } else {
                String modified = result.toModify();
                if (modified != null) {
                    this.debugLogger.debugMultiple(() -> new String[]{"[COMMAND] Modified Command", "Original: " + event.getMessage(), "Modified: " + modified});
                    event.setMessage(modified);
                }
            }
        })).join();
    }

    @Override
    @NotNull
    public Class<PlayerCommandPreprocessEvent> eventClass() {
        return PlayerCommandPreprocessEvent.class;
    }

    @Override
    public boolean isLocal() {
        return WALKER.walk(stream -> stream.limit(15L).map(StackWalker.StackFrame::getMethodType).noneMatch(method -> {
            List<Class<?>> parameters = method.parameterList();
            return parameters.contains(ServerboundChatCommandPacket.class) || parameters.contains(ServerboundChatCommandSignedPacket.class);
        }));
    }
}

