/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.paper.listener;

import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.paper.SignedVelocity;
import io.github._4drian3d.signedvelocity.paper.listener.EventListener;
import java.util.UUID;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.NotNull;

public final class PlayerQuitListener
implements EventListener<PlayerQuitEvent> {
    private final SignedQueue chatQueue;
    private final SignedQueue commandQueue;

    public PlayerQuitListener(SignedVelocity plugin) {
        this.chatQueue = plugin.getChatQueue();
        this.commandQueue = plugin.getCommandQueue();
    }

    @Override
    @NotNull
    public EventPriority priority() {
        return EventPriority.NORMAL;
    }

    @Override
    public boolean ignoreCancelled() {
        return true;
    }

    @Override
    public void handle(@NotNull PlayerQuitEvent event) {
        UUID playerUUID = event.getPlayer().getUniqueId();
        this.chatQueue.removeData(playerUUID);
        this.commandQueue.removeData(playerUUID);
    }

    @Override
    @NotNull
    public Class<PlayerQuitEvent> eventClass() {
        return PlayerQuitEvent.class;
    }
}

