/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.paper.listener;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteStreams;
import io.github._4drian3d.signedvelocity.common.queue.SignedQueue;
import io.github._4drian3d.signedvelocity.common.queue.SignedResult;
import io.github._4drian3d.signedvelocity.paper.SignedVelocity;
import io.github._4drian3d.signedvelocity.shared.types.QueueType;
import io.github._4drian3d.signedvelocity.shared.types.ResultType;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.plugin.messaging.PluginMessageListener;
import org.jetbrains.annotations.NotNull;

public final class PluginMessagingListener
implements PluginMessageListener {
    private final SignedVelocity plugin;

    public PluginMessagingListener(SignedVelocity plugin) {
        this.plugin = plugin;
    }

    public void onPluginMessageReceived(@NotNull String channel, @NotNull Player player, byte @NotNull [] message) {
        if (!Objects.equals(channel, "signedvelocity:main")) {
            return;
        }
        this.plugin.debugLogger().debug(() -> "[Plugin Message] Received on: " + System.currentTimeMillis());
        ByteArrayDataInput input = ByteStreams.newDataInput((byte[])message);
        UUID playerId = UUID.fromString(input.readUTF());
        String source = input.readUTF();
        String result = input.readUTF();
        SignedQueue queue = switch (QueueType.getOrThrow(source)) {
            default -> throw new MatchException(null, null);
            case QueueType.COMMAND -> this.plugin.getCommandQueue();
            case QueueType.CHAT -> this.plugin.getChatQueue();
        };
        SignedResult resulted = switch (ResultType.getOrThrow(result)) {
            default -> throw new MatchException(null, null);
            case ResultType.CANCEL -> SignedResult.cancel();
            case ResultType.MODIFY -> SignedResult.modify(input.readUTF());
            case ResultType.ALLOWED -> SignedResult.allowed();
        };
        queue.dataFrom(playerId).complete(resulted);
        this.plugin.debugLogger().debugMultiple(() -> new String[]{"[Plugin Message] Received Valid Message", "| Queue: " + source, "| Result: " + result, "| Message: " + resulted.message()});
    }
}

