/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.paper.utils;

import io.github._4drian3d.signedvelocity.shared.PropertyHolder;
import io.papermc.paper.event.player.ChatEvent;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.StringJoiner;
import java.util.stream.Stream;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.AsyncPlayerChatPreviewEvent;
import org.bukkit.event.player.PlayerChatEvent;
import org.bukkit.plugin.RegisteredListener;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public final class DeprecatedUsageAlert {
    public static final boolean LEGACY_PLUGIN_WARNING = PropertyHolder.readBoolean("io.github._4drian3d.signedvelocity.legacyPluginWarning", true);

    public static void blameAboutLegacyPlugins(Logger logger) {
        Stream.of(new LegacyEvent<AsyncPlayerChatEvent>(AsyncPlayerChatEvent.class, AsyncPlayerChatEvent.getHandlerList()), new LegacyEvent<PlayerChatEvent>(PlayerChatEvent.class, PlayerChatEvent.getHandlerList()), new LegacyEvent<ChatEvent>(ChatEvent.class, ChatEvent.getHandlerList()), new LegacyEvent<AsyncPlayerChatPreviewEvent>(AsyncPlayerChatPreviewEvent.class, AsyncPlayerChatPreviewEvent.getHandlerList())).filter(event -> event.listeners.length != 0).forEach(event -> event.printWarning(logger));
    }

    private record LegacyEvent<E extends Event>(Class<E> clazz, RegisteredListener[] listeners) {
        LegacyEvent(Class<E> clazz, HandlerList handlerList) {
            this(clazz, handlerList.getRegisteredListeners());
        }

        private void printWarning(Logger logger) {
            logger.warn("------------------------------");
            String legacyPluginList = this.legacyPluginList();
            logger.warn("The following plugins have listener in legacy {} event: {}", (Object)this.clazz.getName(), (Object)legacyPluginList);
            logger.warn("This may negatively affect the functionality of SignedVelocity,");
            logger.warn("please report to the author to use Paper's AsyncChatEvent and/or AsyncChatDecorateEvent.");
            logger.warn("------------------------------");
        }

        @NotNull
        private String legacyPluginList() {
            StringJoiner builder = new StringJoiner(", ", "", ".");
            ObjectArraySet legacyPlugins = new ObjectArraySet(this.listeners.length);
            for (RegisteredListener listener : this.listeners) {
                String pluginName = listener.getPlugin().getPluginMeta().getName();
                if (!legacyPlugins.add(pluginName)) continue;
                builder.add(pluginName);
            }
            return builder.toString();
        }
    }
}

