/*
 * Decompiled with CFR 0.152.
 */
package io.github._4drian3d.signedvelocity.shared.logger;

import io.github._4drian3d.signedvelocity.shared.PropertyHolder;
import java.util.function.Supplier;
import org.slf4j.Logger;

public interface DebugLogger {
    public static final boolean DEBUG = PropertyHolder.readBoolean("io.github._4drian3d.signedvelocity.debug", false);

    public void debugMultiple(Supplier<String[]> var1);

    public void debug(Supplier<String> var1);

    public record Slf4j(Logger logger) implements DebugLogger
    {
        @Override
        public void debugMultiple(Supplier<String[]> supplier) {
            if (DEBUG) {
                for (String line : supplier.get()) {
                    this.logger.info("[DEBUG] {}", (Object)line);
                }
            }
        }

        @Override
        public void debug(Supplier<String> supplier) {
            if (DEBUG) {
                this.logger.info("[DEBUG] {}", (Object)supplier.get());
            }
        }
    }
}

