/*
 * Decompiled with CFR 0.152.
 */
package dev.gabereal.eplayers;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EliminatePlayers
implements ModInitializer {
    public static final String MOD_ID = "eliminateplayers";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"eliminateplayers");
    public static final class_2960 CONFIG_CHECK_PACKET = new class_2960("eliminateplayers", "config_check");
    public static final class_2960 CONFIG_RESPONSE_PACKET = new class_2960("eliminateplayers", "config_response");
    public static final ArrayList<UUID> bannedUuids = new ArrayList();
    private static final Set<UUID> verifiedPlayers = new HashSet<UUID>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("eliminateplayers.json");

    public void onInitialize() {
        this.loadConfig();
        LOGGER.info("Loaded {} banned UUIDs on {}", (Object)bannedUuids.size(), (Object)FabricLoader.getInstance().getEnvironmentType());
        if (FabricLoader.getInstance().getEnvironmentType().name().equals("SERVER")) {
            this.setupServerHandlers();
        }
    }

    private void setupServerHandlers() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            LOGGER.info("Player joined, will check config in 1 second: {}", (Object)player.method_5477().getString());
            server.execute(() -> {
                try {
                    Thread.sleep(1000L);
                    if (!player.field_13987.method_48106()) {
                        return;
                    }
                    LOGGER.info("Sending config check to player: {}", (Object)player.method_5477().getString());
                    class_2540 buf = PacketByteBufs.create();
                    buf.writeInt(bannedUuids.size());
                    for (UUID uuid : bannedUuids) {
                        buf.method_10814(uuid.toString());
                    }
                    ServerPlayNetworking.send((class_3222)player, (class_2960)CONFIG_CHECK_PACKET, (class_2540)buf);
                    Thread.sleep(15000L);
                    if (player.field_13987.method_48106() && !verifiedPlayers.contains(player.method_5667())) {
                        this.kickPlayerWithInstructions(player, "Config mismatch between servers or mod may not be installed!");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception e) {
                    LOGGER.error("Error during config check for player {}: {}", (Object)player.method_5477().getString(), (Object)e.getMessage());
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CONFIG_RESPONSE_PACKET, (server, player, handler, buf, responseSender) -> {
            boolean configMatches = buf.readBoolean();
            if (!configMatches) {
                server.execute(() -> this.kickPlayerWithInstructions(player, "Config mismatch - banned UUIDs don't match server"));
            } else {
                verifiedPlayers.add(player.method_5667());
                LOGGER.info("Player {} has correct config - allowing connection", (Object)player.method_5477().getString());
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> verifiedPlayers.remove(handler.method_32311().method_5667()));
    }

    private void kickPlayerWithInstructions(class_3222 player, String reason) {
        StringBuilder instructions = new StringBuilder();
        instructions.append("\u00a7c\u00a7lCONFIG MISMATCH\u00a7r\n\n");
        instructions.append("\u00a7eYou need to update your EliminatePlayers config!\n\n");
        instructions.append("\u00a76Required banned UUIDs:\n");
        for (UUID uuid : bannedUuids) {
            instructions.append("\u00a77- ").append(uuid.toString()).append("\n");
        }
        instructions.append("\n\u00a7eSteps to fix:\n");
        instructions.append("\u00a77If you're using the minecraft launcher, follow below \u2193\n");
        instructions.append("\u00a771. Go to your .minecraft/config/ folder\n");
        instructions.append("\u00a772. Open eliminateplayers.json\n");
        instructions.append("\u00a773. Update the bannedUuids list to match above\n");
        instructions.append("\u00a774. Restart your client and rejoin\n\n");
        instructions.append("\u00a77If you're using Modrinth, go to https://github.com/Gabe-Real/eliminate-players/Modrinth.mdx\n");
        instructions.append("\u00a77If you're using Prism, go to https://github.com/Gabe-Real/eliminate-players/Prism.mdx\n");
        instructions.append("\u00a77If you want to find a uuid, go to https://mcuuid.net/\n\n");
        instructions.append("\u00a7cReason: ").append(reason);
        player.field_13987.method_14367((class_2561)class_2561.method_43470((String)instructions.toString()));
        LOGGER.info("Kicked player {} due to config mismatch: {}", (Object)player.method_5477().getString(), (Object)reason);
    }

    private void loadConfig() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            this.createDefaultConfig();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            Config config = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (config != null && config.bannedUuids != null) {
                for (String uuidString : config.bannedUuids) {
                    try {
                        bannedUuids.add(UUID.fromString(uuidString));
                    }
                    catch (IllegalArgumentException e) {
                        LOGGER.warn("Invalid UUID in config: {}", (Object)uuidString);
                    }
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
            this.createDefaultConfig();
        }
    }

    private void createDefaultConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Config defaultConfig = new Config();
            defaultConfig.bannedUuids = List.of("d0815131-c51a-4831-b973-f69da01e6326");
            try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                GSON.toJson((Object)defaultConfig, (Appendable)writer);
            }
            bannedUuids.add(UUID.fromString("d0815131-c51a-4831-b973-f69da01e6326"));
            LOGGER.info("Created default config at {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default config", (Throwable)e);
        }
    }

    public static class Config {
        public List<String> bannedUuids = new ArrayList<String>();
    }
}

