/*
 * Decompiled with CFR 0.152.
 */
package dev.gabereal.eplayers;

import dev.gabereal.eplayers.EliminatePlayers;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class EliminatePlayersClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)EliminatePlayers.CONFIG_CHECK_PACKET, (client, handler, buf, responseSender) -> {
            boolean matches;
            EliminatePlayers.LOGGER.info("Received config check from server");
            int count = buf.readInt();
            ArrayList<String> serverUuids = new ArrayList<String>();
            for (int i = 0; i < count; ++i) {
                serverUuids.add(buf.method_19772());
            }
            EliminatePlayers.LOGGER.info("Server sent {} UUIDs", (Object)count);
            if (EliminatePlayers.bannedUuids.isEmpty()) {
                EliminatePlayers.LOGGER.warn("Client config appears to be empty, this will cause a mismatch");
            }
            EliminatePlayers.LOGGER.info("Config comparison result: {}", (Object)((matches = this.compareConfigs(serverUuids)) ? "MATCH" : "MISMATCH"));
            class_2540 response = PacketByteBufs.create();
            response.writeBoolean(matches);
            ClientPlayNetworking.send((class_2960)EliminatePlayers.CONFIG_RESPONSE_PACKET, (class_2540)response);
        });
    }

    private boolean compareConfigs(List<String> serverUuids) {
        ArrayList<String> clientUuids = new ArrayList<String>();
        for (UUID uuid : EliminatePlayers.bannedUuids) {
            clientUuids.add(uuid.toString().toLowerCase());
        }
        ArrayList<String> normalizedServerUuids = new ArrayList<String>();
        for (String uuid : serverUuids) {
            normalizedServerUuids.add(uuid.toLowerCase());
        }
        EliminatePlayers.LOGGER.info("Client UUIDs: {}", clientUuids);
        EliminatePlayers.LOGGER.info("Server UUIDs: {}", normalizedServerUuids);
        if (normalizedServerUuids.size() != clientUuids.size()) {
            EliminatePlayers.LOGGER.warn("Size mismatch - Server: {}, Client: {}", (Object)normalizedServerUuids.size(), (Object)clientUuids.size());
            return false;
        }
        for (String serverUuid : normalizedServerUuids) {
            if (clientUuids.contains(serverUuid)) continue;
            EliminatePlayers.LOGGER.warn("Server UUID not found in client config: {}", (Object)serverUuid);
            return false;
        }
        EliminatePlayers.LOGGER.info("Config comparison successful - UUIDs match!");
        return true;
    }
}

